/*
ESUP-portail is a french academic project developed under the GPL (General Public License) augmented according to the following :
A binary or source file developped by ESUP-portail can be used or compiled with products under Apache license.
The official english text of the GPL can be found here : http://www.gnu.org/licenses/gpl.html .
A non official french translation can be found here : http://www.linux-France.org/article/these/gpl.html .
The different kinds of licenses governing the products developed by the Apache foundation can be found here : http://www.apache.org/licenses .
It follows that you can as well as use download contents as well modify and redistribute them provided you respect the GPL terms.
Downloading and using such contents do not provide any guaranty.
Be sure that you have well understood the terms of the license before using the contents it covers.
The ESUP-portail distribution includes the following distributions :
    * UPortal : 
      software developed by JA-SIG (Java Architecture - Special Interest Group)
      You can find the license page here : http://mis105.udel.edu/ja-sig/uportal/license.html
    * CAS :
      SSO solution developed by Yale University
      You can find the project page here : http://www.yale.edu/tp/auth
    * Cocoon :
      XML framework distributed by the Apache foundation under Apache license;
      Please find the full text here : http://cocoon.apache.org/2.1/license.html
    * Mod_dav:
      A DAV module for Apache web server
      You can find the project page here : http://www.webdav.org/mod_dav
    * IMP :
      webmail from Horde application framework
      You can find the project page here : http://www.horde.org
    * . To be completed
*/
package org.esupportail.portal.channels.CSMS;

import java.util.Iterator;
import java.util.Vector;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.esupportail.portal.channels.CSMS.exception.ExceptionAccesLdap;
import org.esupportail.portal.channels.CSMS.exception.ExceptionCanal;
import org.esupportail.portal.channels.CSMS.exception.ExceptionConfigurationCanal;
import org.esupportail.portal.channels.CSMS.exception.ExceptionConfirmationEnvoiSms;
import org.esupportail.portal.channels.CSMS.exception.ExceptionEnvoi;
import org.esupportail.portal.channels.CSMS.exception.ExceptionEnvoiMail;
import org.esupportail.portal.channels.CSMS.exception.ExceptionEnvoiSms;
import org.esupportail.portal.channels.CSMS.properties.ParseProprietesCanal;
import org.esupportail.portal.channels.CSMS.properties.ProprietesCanal;
import org.esupportail.portal.channels.CSMS.serverSending.GereDestinataire;
import org.esupportail.portal.channels.CSMS.serverSending.GereMessage;
import org.jasig.portal.ChannelRuntimeData;
import org.jasig.portal.PortalException;
import org.jasig.portal.utils.XSLT;
import org.xml.sax.ContentHandler;

/**
 * Id: ActionEnvoiMessage.java,v 1.0 3 janv. 2005
 * Copyright (c) 2004 Esup Portail (www.esup-portail.org)
 * Classes: ActionEnvoiMessage
 * Original Author: Yohan Colmant
 * Gere les actions lors de l'envoi de messages
 */
public class ActionEnvoiMessage {


	/**
	 * Logger object
	 */
	protected static final Log log = LogFactory.getLog(ActionEnvoiMessage.class);
	
	
	/**
	 * Action de saisie de message
	 */
	private String MESSAGE_ACTION = "actionMessage";
	
	/**
	 * Action de saisie de destinataire
	 */
	private String DEST_ACTION = "actionDestinataire";
	

	/**
	 * Action de confirmation d'envoi
	 */
	private String CONFIRM_ACTION = "actionConfirmation";	
	
	/**
	 * Action de saisie de resultat
	 */
	private String RESULT_ACTION = "actionResultat";
	
	

	/**
	 * Objet qui permet de gerer le destinataire du message
	 */
	private GereDestinataire dest;
	
	/**
	 * Objet qui permet de gerer le message qu'on envoit
	 */
	private GereMessage mess;
	
	


	/**
	 * La feuille de style utilisee
	 */
	private String stylesheet;
	
	
	
	
	
	/**
	 * Constructeur par defaut
	 * @param login le login de la personne connectee
	 */
	public ActionEnvoiMessage(String login) {
		
		try {
			// on initialise les classes de gestion d'envoi
			this.dest = new GereDestinataire();
			this.mess = new GereMessage();	
			
			// on affecte le login, le nom et le mail de l'expediteur du message
			mess.setLoginNomMailExpediteur(login);	
		}
		catch(ExceptionConfigurationCanal e) {
			log.error("ActionEnvoiMessage: "+e);	
		}
		
		
	}
	
	
	
	
	
	
	/**
	 * Output channel content to the portal
	 * @param out a sax document handler
	 * @param xslt object used for the rendering
	 * @param runtimeData the channelRuntimeData object
	 * @throws PortalException
	 */
	public void renderXML(ContentHandler out, XSLT xslt, ChannelRuntimeData runtimeData) throws PortalException {				
		
		String action = runtimeData.getParameter("action");		
		
		//System.out.println("action="+action);
		
		// le XML a generer
		String xml = "<?xml version=\"1.0\" encoding=\"utf-8\"?>";		
		xml += "<ROOT>";
		
		try {
			
			stylesheet = "message_envoi";
			
			if (log.isDebugEnabled()){
				log.debug("renderXML : action selectionnee="+action);
			}	
			
			// si action est null, on est en mode message
			//System.out.println("action =" + action);
			if (action == null || action.equals("null")) {
				action = MESSAGE_ACTION;			
				stylesheet = "message_envoi";
			}
			
			
			
			// si on est en edition de message
			if (action.equals(MESSAGE_ACTION)) {
				xml += renderXmlSaisieMessage();
				stylesheet = "message_envoi";
			}
			
			// si on est en selection de destinataire
			else if (action.equals(DEST_ACTION)) {
					String msg = runtimeData.getParameter("message");
					if (msg!=null) {
						this.mess.setMessage(msg);
						this.mess.setSujet(runtimeData.getParameter("sujet"));
					}				
				xml += renderXmlSaisieDestinataire(runtimeData);
				stylesheet = "destinataire_envoi";
			} 
			
			// si on est en selection de destinataire
			else if (action.equals(CONFIRM_ACTION)) {
				xml += renderXmlConfirm(runtimeData);
				stylesheet = "confirm_envoi";
			}
			
			// si on affiche le resultat de la requete
			else if (action.equals(RESULT_ACTION)) {
				xml += renderXmlResultat();
				stylesheet = "result_envoi";					
			}
			
		}
		catch(ExceptionCanal e) {
			xml += renderXmlMessage(e.getErrorCode(), e.getNextState());
			stylesheet = "message_profil";
			if (log.isDebugEnabled()){
				log.debug("renderXML"+" :: "+e);
			}	
		}
		
		
		
		// fin du XML
		xml += "</ROOT>";
		
		
		// pass the result XML to the styling engine.
		xslt.setXML(xml);
		// specify the stylesheet selector
		xslt.setXSL("CSMS.ssl", stylesheet, runtimeData.getBrowserInfo());
		// set parameters that the stylesheet needs.
		xslt.setStylesheetParameter("baseActionURL", runtimeData.getBaseActionURL());	
		// set the output Handler for the output.
		xslt.setTarget(out);
		// do the deed
		xslt.transform();
	}
	
	

	
	/**
	 * On genere le XML de sortie pour l'affichage d'un message
	 * @param messageCode le code de message a afficher
	 * @param etatSuivant l'etat dans lequel devra se retrouver le canal apres ce message
	 * @return le XML
	 */
	private String renderXmlMessage(int messageCode, String etatSuivant) {		
		String xml = "";						
		xml += "<MESSAGE state=\""+etatSuivant+"\">"+messageCode+"</MESSAGE>";		
		return xml;
	}
	
	
	
	
	/**
	 * On genere le XML de sortie pour la saisie de message
	 * @return le XML
	 * @throws ExceptionConfigurationCanal
	 */	
	private String renderXmlSaisieMessage () throws ExceptionConfigurationCanal {
		ProprietesCanal prop = ParseProprietesCanal.getInstance();
		String tailleG = prop.getSmsSize();
		int tailleGlobale = Integer.parseInt(tailleG);		
		int tailleCaracteresSpeciaux = 5;
		int tailleNom = mess.getNomExpediteur().length();		
		int tailleFrom = prop.getSmsFrom().length();		
		
		int taillePossible = tailleGlobale - (tailleCaracteresSpeciaux + tailleNom + tailleFrom);		
		String tailleXml = "<TAILLE>"+taillePossible+"</TAILLE>";
		
		String xml = "<MESSAGE>" + tailleXml + "<SUJET>";
		
		String sujet = mess.getSujet();
		String message = mess.getMessage();
		
		if (sujet!=null)
			xml += sujet;
		xml += "</SUJET>" + "<CORPS>";
		if (message!=null)
			xml += message;
		xml += "</CORPS>" + "</MESSAGE>";
		return xml;
	}
	
	
	/**
	 * On genere le XML de sortie pour la saisie du destinataire
	 * @param runtimeData l'objet ChannelRuntimeData du canal
	 * @return le XML
	 * @throws ExceptionAccesLdap
	 * @throws ExceptionConfigurationCanal
	 */
	private String renderXmlSaisieDestinataire(ChannelRuntimeData runtimeData) throws ExceptionAccesLdap, ExceptionConfigurationCanal {		
		
		try {
			String xml = "";
			
				xml += "<DESTINATAIRE>";
																
				xml	+= "<INSTITUTS>";
				
				
				// si on n'a pas encore la liste des instituts, on la charge
				if (dest.listeInstitutsVide()) {
					if (log.isDebugEnabled()){
						log.debug("renderXmlSaisieDestinataire : aucun institut encore charge, je vais chercher dans le LDAP");
					}	
					dest.loadInstituts();
				}
			
				// on regarde si l'institut a deja ete selectionne
				String institut = runtimeData.getParameter("institut");
				if (log.isDebugEnabled()){
					log.debug("renderXmlSaisieDestinataire : institut = "+institut);
				}	
				if (institut != null) {
					if (log.isDebugEnabled()){
						log.debug("renderXmlSaisieDestinataire : j'ai choisi l'institut "+institut);
					}	
					dest.setInstitutSelectionne(institut);
					if (!dest.aucuneFormationSelectionnee())
						dest.setFormationSelectionne(null);
					if (destinataires!=null)
						destinataires.clear();				
				}
					
				if (dest.aucunInstitutSelectionne()) {
					Iterator iter = dest.getInstitutsIterator();
					while (iter.hasNext()) {
						xml += "<INSTITUT>"+iter.next()+"</INSTITUT>";
					}
				}
				else {
					Iterator iter = dest.getInstitutsIterator();
					while (iter.hasNext()) {
						String inst = (String)iter.next();
						if (inst.trim().toLowerCase().equals( dest.getInstitutSelectionne().trim().toLowerCase()))
							xml += "<INSTITUT SELECTED=\"true\">"+inst+"</INSTITUT>";
						else xml += "<INSTITUT>"+inst+"</INSTITUT>";
					}
				}
				xml += "</INSTITUTS>";
				
	
				// on regarde si la formation a deja ete selectionnee		
				if ( !dest.aucunInstitutSelectionne() ) {
					
					xml += "<FORMATIONS>";
			
					// on regarde si la formation a deja ete selectionnee et on va chercher la liste des formations
					String formation = runtimeData.getParameter("formation");
					if (formation!=null) {
						dest.setFormationSelectionne(formation);
						if (destinataires!=null)
							destinataires.clear();
					}
			
					dest.loadFormations(dest.getInstitutSelectionne());		
					if ( dest.aucuneFormationSelectionnee()) {
						Iterator iter = dest.getFormationsIterator();
						while (iter.hasNext()) {
							xml += "<FORMATION>"+iter.next()+"</FORMATION>";
						}
					}
					else {
						Iterator iter = dest.getFormationsIterator();
						while (iter.hasNext()) {
							String form = (String)iter.next();
							if (form.toLowerCase().equals( dest.getFormationSelectionnee().toLowerCase()))
								xml += "<FORMATION SELECTED=\"true\">"+form+"</FORMATION>";
							else xml += "<FORMATION>"+form+"</FORMATION>";
						}
					}
					xml += "</FORMATIONS>";
				}
				
				// les etudiants selectionnes		
				dest.loadEtudiants(dest.getFormationSelectionnee());
				if (!dest.aucuneFormationSelectionnee()) {
					xml += "<ETUDIANTS>";
					Iterator iter = dest.getEtudiantsIterator();
					int index = 1;
					while (iter.hasNext()) {
						//xml += "<ETUDIANT NOM=\""+iter.next()+"\" index=\""+index+"\" />";
						
						if ( dest.indicesEtudiantsSelectionnesContains(index) ) {
							xml += "<ETUDIANT SELECTED=\"true\" NOM=\""+iter.next()+"\" index=\""+index+"\" />";
						}
						else {
							xml += "<ETUDIANT NOM=\""+iter.next()+"\" index=\""+index+"\" />";
						}
						
						index++;
					}		
					xml += "</ETUDIANTS>";				
				}			
				xml += "</DESTINATAIRE>";
				
				return xml;
		}
		catch(ExceptionAccesLdap e) {
			e.setNextState(MESSAGE_ACTION);
			throw e;
		}	
		
	}
	
	
	/**
	 * Creation du XML pour le choix du destinataire, mais avec affichage d'un message d'erreur, et aussi garde des choix faits auparavant
	 * On suppose que on a deja la liste des instituts, formations et etudiants
	 * @return la page XML
	 */
	/*private String renderXmlDestinataire() {		
		String xml = "";
		xml += "<DESTINATAIRE>"
			+ "<INSTITUTS>";
		
		// on regarde si l'institut a deja ete selectionne		
		if (  dest.aucunInstitutSelectionne() ) {
			Iterator iter = dest.getInstitutsIterator();
			while (iter.hasNext()) {
				xml += "<INSTITUT>"+iter.next()+"</INSTITUT>";
			}
		}
		else {
			Iterator iter = dest.getInstitutsIterator();
			while (iter.hasNext()) {
				String inst = (String)iter.next();
				if (inst.trim().toLowerCase().equals( dest.getInstitutSelectionne().trim().toLowerCase()))
					xml += "<INSTITUT SELECTED=\"true\">"+inst+"</INSTITUT>";
				else xml += "<INSTITUT>"+inst+"</INSTITUT>";
			}
		}
		xml += "</INSTITUTS>";		
		
		
		// on regarde si la formation a deja ete selectionnee		
		if ( !dest.aucunInstitutSelectionne() ) {
			
			xml += "<FORMATIONS>";
			if ( dest.aucuneFormationSelectionnee()) {
				Iterator iter = dest.getFormationsIterator();
				while (iter.hasNext()) {
					xml += "<FORMATION>"+iter.next()+"</FORMATION>";
				}
			}
			else {
				Iterator iter = dest.getFormationsIterator();
				while (iter.hasNext()) {
					String form = (String)iter.next();
					if (form.toLowerCase().equals( dest.getFormationSelectionnee().toLowerCase()))
						xml += "<FORMATION SELECTED=\"true\">"+form+"</FORMATION>";
					else xml += "<FORMATION>"+form+"</FORMATION>";
				}
			}
		xml += "</FORMATIONS>";
		}
		
		// les etudiants selectionnes		
		if ( !dest.aucuneFormationSelectionnee() ) {
			xml += "<ETUDIANTS>";
			Iterator iter = dest.getEtudiantsIterator();
			int i = 1;
			while (iter.hasNext()) {
				// si il est selectionne
				if ( dest.indicesEtudiantsSelectionnesContains(i) ) {
					xml += "<ETUDIANT SELECTED=\"true\" NOM=\""+iter.next()+"\" />";
				}
				else {
					xml += "<ETUDIANT NOM=\""+iter.next()+"\" />";
				}
				i++;
			}		
			xml += "</ETUDIANTS>";
		}			
		xml += "</DESTINATAIRE>";
		
		return xml;
	}*/
	
	
	
	
	/**
	 * Les destinataires du message
	 */
	Vector destinataires = null;
	

	/**
	 * On genere le XML de sortie pour la confirmation de l'envoi
	 * @param runtimeData l'objet ChannelRuntimeData du canal
	 * @return le XML
	 */
	private String renderXmlConfirm (ChannelRuntimeData runtimeData) {
		String xml = "";		
		
		String[] etudiants = runtimeData.getParameterValues("etudiants");
		
		//String numsEtudiants = runtimeData.getParameter("etudiants");		
		destinataires = new Vector();
		
		// on prend tous les etudiants
		if (etudiants[0].equals("0")) {
			Iterator iter = dest.getEtudiantsIterator();
			dest.initIndicesEtudiantsSelectionnes();			
			dest.addIndiceEtudiantSelectionne("0");
			while (iter.hasNext()) {
				Etudiant etudiant = (Etudiant)iter.next();
				//System.out.println("destinataire: "+etudiant.getName()+" "+etudiant.getEmail()+" "+etudiant.getPhone());
				destinataires.addElement(etudiant);
			}			
		}
	
		// on selectionne certains etudiants
		else {
			//StringTokenizer strToken = new StringTokenizer(numsEtudiants, "-");
			dest.initIndicesEtudiantsSelectionnes();
			for (int i=0; i<etudiants.length; i++) //strToken.hasMoreTokens())
				dest.addIndiceEtudiantSelectionne((String)etudiants[i]);
			
			
			Object[] tabEtudiants = dest.getArrayOfEtudiants();
			for (int i=0; i< dest.getIndicesEtudiantsSelectionnesSize(); i++) {
				int indice = dest.getIndiceEtudiantSelectionne(i);
				Etudiant etudiant = (Etudiant)tabEtudiants[indice-1];
				//System.out.println("destinataire: "+etudiant.getName()+" "+etudiant.getEmail()+" "+etudiant.getPhone());
				destinataires.addElement(etudiant);
			}			
		}
		
		
		// on genere la liste des etudiants
		for (int i=0; i<destinataires.size(); i++) {
			Etudiant etudiant = (Etudiant)destinataires.elementAt(i);
			
			String nom = etudiant.getName();
			String telephone = etudiant.getPhone();
			String courriel = etudiant.getEmail();
			
			xml += "<destinataire phone=\""+telephone+"\" mail=\""+courriel+"\">";
			xml += nom;
			xml += "</destinataire>";						
		}
		
		xml += "";
				
		return xml;		
	}
	
	
	
	
	
	/**
	 * On genere le XML de sortie pour l'affichage du resultat de l'envoi quand celui-ci a ete possible
	 * @return le XML
	 * @throws ExceptionEnvoi
	 * @throws ExceptionConfirmationEnvoiSms
	 * @throws ExceptionConfigurationCanal
	 */
	private String renderXmlResultat () throws ExceptionEnvoi, ExceptionConfirmationEnvoiSms, ExceptionConfigurationCanal {
		String xml = "";
		
		boolean mailOk = true;
		boolean smsOk = true;
		
		// on envoie le message
		try {
			mess.sendMessage(destinataires);
		}
		catch(ExceptionEnvoiMail e) {			
			mailOk = false;
		}
		catch(ExceptionEnvoiSms e) {			
			smsOk = false;
		}
		catch(ExceptionEnvoi e) {			
			// si ca s'est mal passe, on propage une exception pour revenir en mode de saisie de destinataire
			e.setNextState(this.DEST_ACTION);
			throw e;
		}
		catch(ExceptionConfirmationEnvoiSms e) {			
			// si ca s'est mal passe, on propage une exception pour revenir en mode de saisie de destinataire
			e.setNextState(this.DEST_ACTION);
			throw e;
		}
		
		
		// si ca s'est bien passe au moins pour sms ou mail, voici le xml a afficher			
		xml += "<RESULTAT>";
		
		xml += "<ENVOI mailOk=\""+mailOk+"\" smsOk=\""+smsOk+"\"/>";
		
		xml += "</RESULTAT>";			
		
		// init destinataire
		dest.initEtudiants();
		dest.initFormations();
		dest.initInstituts();	
		
		return xml;		
	}
	
	
	
	
	
	
	
	
}
