/*
ESUP-portail is a french academic project developed under the GPL (General Public License) augmented according to the following :
A binary or source file developped by ESUP-portail can be used or compiled with products under Apache license.
The official english text of the GPL can be found here : http://www.gnu.org/licenses/gpl.html .
A non official french translation can be found here : http://www.linux-France.org/article/these/gpl.html .
The different kinds of licenses governing the products developed by the Apache foundation can be found here : http://www.apache.org/licenses .
It follows that you can as well as use download contents as well modify and redistribute them provided you respect the GPL terms.
Downloading and using such contents do not provide any guaranty.
Be sure that you have well understood the terms of the license before using the contents it covers.
The ESUP-portail distribution includes the following distributions :
    * UPortal : 
      software developed by JA-SIG (Java Architecture - Special Interest Group)
      You can find the license page here : http://mis105.udel.edu/ja-sig/uportal/license.html
    * CAS :
      SSO solution developed by Yale University
      You can find the project page here : http://www.yale.edu/tp/auth
    * Cocoon :
      XML framework distributed by the Apache foundation under Apache license;
      Please find the full text here : http://cocoon.apache.org/2.1/license.html
    * Mod_dav:
      A DAV module for Apache web server
      You can find the project page here : http://www.webdav.org/mod_dav
    * IMP :
      webmail from Horde application framework
      You can find the project page here : http://www.horde.org
    * . To be completed
*/
package org.esupportail.portal.channels.CSMS.log;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;


/**
 * <p>Titre : LogReader</p>
 * <p>Description : Classe permettant de lire un fichier de log </p>
 * <p>Copyright : Copyright (c) 2004</p>
 * <p>Socit : Universit de Valenciennes et du Hainaut Cambrsis </p>
 * @author Yohan Colmant
 * @version 1.0
 */
public class LogReader {
	
	
	/**
	 * La ligne suivante dans le log
	 */
	private String next;
	
	/**
	 * Le lecteur de fichier
	 */
	private BufferedReader out;
	
	
	
	/**
	 * Constructeur
	 * @param fichier le nom du fichier de log
	 * @throws IOException
	 */
	public LogReader(String fichier) throws IOException {
		
		// On ouvre le fichier
		out = new BufferedReader(new FileReader(fichier));
		
		// On lit la premiere ligne de commentaires
		out.readLine();
		
		// On lit la premiere ligne de donnees
		next = out.readLine();
	}
	
	/**
	 * Dit si il y a un element suivant dans le log
	 * @return true si il y a un element suivant dans le log
	 */
	public boolean hasNext() {
		if (next != null)
			return true;
		else return false;
	}
	
	/**
	 * Retourne l'element suivant dans le log
	 * @return l'element suivant dans le log
	 * @throws IOException
	 */
	public LogLine next() throws IOException {
		if (next != null) {
			LogLine ligne = new LogLine(next);
			next = out.readLine();
			return ligne;
		}
		else return null;
	}
	
	/**
	 * Ferme le lecteur
	 * @throws IOException
	 */
	public void close() throws IOException {
		out.close();
	}
	
	
}
