/*
ESUP-portail is a french academic project developed under the GPL (General Public License) augmented according to the following :
A binary or source file developped by ESUP-portail can be used or compiled with products under Apache license.
The official english text of the GPL can be found here : http://www.gnu.org/licenses/gpl.html .
A non official french translation can be found here : http://www.linux-France.org/article/these/gpl.html .
The different kinds of licenses governing the products developed by the Apache foundation can be found here : http://www.apache.org/licenses .
It follows that you can as well as use download contents as well modify and redistribute them provided you respect the GPL terms.
Downloading and using such contents do not provide any guaranty.
Be sure that you have well understood the terms of the license before using the contents it covers.
The ESUP-portail distribution includes the following distributions :
    * UPortal : 
      software developed by JA-SIG (Java Architecture - Special Interest Group)
      You can find the license page here : http://mis105.udel.edu/ja-sig/uportal/license.html
    * CAS :
      SSO solution developed by Yale University
      You can find the project page here : http://www.yale.edu/tp/auth
    * Cocoon :
      XML framework distributed by the Apache foundation under Apache license;
      Please find the full text here : http://cocoon.apache.org/2.1/license.html
    * Mod_dav:
      A DAV module for Apache web server
      You can find the project page here : http://www.webdav.org/mod_dav
    * IMP :
      webmail from Horde application framework
      You can find the project page here : http://www.horde.org
    * . To be completed
*/
package org.esupportail.portal.channels.CSMS.serverSending;

import java.rmi.RemoteException;
import java.util.Vector;

import javax.xml.rpc.ServiceException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.esupportail.portal.channels.CSMS.Etudiant;
import org.esupportail.portal.channels.CSMS.exception.ExceptionConfigurationCanal;
import org.esupportail.portal.channels.CSMS.exception.ExceptionConfirmationEnvoiSms;
import org.esupportail.portal.channels.CSMS.exception.ExceptionParametresEnvoiSms;
import org.esupportail.portal.channels.CSMS.exception.ExceptionServeurSmsIndisponible;
import org.esupportail.portal.channels.CSMS.properties.ParseProprietesCanal;

/**
 * Id: EnvoieSms.java,v 1.0 1 dc. 2004
 * Copyright (c) 2004 Esup Portail (www.esup-portail.org)
 * Classes: EnvoieSms
 * Original Author: Yohan Colmant
 * 
 */
public class EnvoieSms {
	
	/**
	 * Logger object
	 */
	protected static final Log log = LogFactory.getLog(EnvoieSms.class);
	

	/**
	 * Sujet du message
	 */
	private String sujet;
	
	/**
	 * Corps du message
	 */
	private String message;

	
	
	
	/**
	 * L'identifiant client
	 */
	private String custId;
	
	
	/**
	 * La strategie adopte
	 */
	private String strategy;
	
	
	
	/**
	 * Le nom de l'expediteur
	 */
	private String nomExpediteur;
	
	
	
	/**
	 * L'id du message envoye
	 */
	private String id;
	
	
	/**
	 * Connexion au WS
	 */
	private PostWSConnection conn;
	
	
	
	
	/**
	 * Constructeur
	 * @param sujet sujet du message
	 * @param message corps du message
	 * @param custId le numero de client
	 * @param strategy la strategie a employer
	 * @param loginExpediteur le login de l'expediteur
	 * @param nomExpediteur le nom de l'expediteur
	 */
	public EnvoieSms(String sujet, String message, String custId, String strategy, String nomExpediteur) throws ExceptionServeurSmsIndisponible, ExceptionConfigurationCanal {
		this.sujet = sujet;
		this.message = message;
		this.custId = custId;
		this.strategy = strategy;
		this.nomExpediteur = nomExpediteur;
		
		try {
			if (conn == null) {
				conn = new PostWSConnection();
			}
		}
		catch(ServiceException e) {
			log.error("EnvoieSms: "+e);
			
			// on propage une nouvelle exception
			throw new ExceptionServeurSmsIndisponible();
		} 
	}
	
	
	/**
	 * Retourne l'id du message envoye
	 * @return l'id du message envoye
	 */
	public String getID() {
		return this.id;
	}
	
	
	

	/**
	 * Pour generer un destinataire dans le fichier XML de profil
	 * @param name nom du destinataire
	 * @param id id du destinataire
	 * @param phone telephone du destinataire
	 * @return une string au format xml
	 */
	private String createProfileDest(String name, String id, String phone) {
		String xml = "";
		
		if ( phone!=null ) {
			xml += "<PROFILE>";
			xml += "<DEST_NAME>" + name + "</DEST_NAME>\n";
			xml += "<DEST_FORENAME>" + name + "</DEST_FORENAME>\n";
			xml += "<DEST_ID>" + id + "</DEST_ID>\n";
			xml += "<TERMINAL_GROUP>\n";
			
			xml += "<TERMINAL>\n";
			xml += "<TERMINAL_NAME>personnal_mobile</TERMINAL_NAME>\n";
			xml += "<TERMINAL_ADDR>" + phone + "</TERMINAL_ADDR>\n";
			xml += "<MEDIA_TYPE_GROUP>\n";
			xml += "<MEDIA_TYPE>sms</MEDIA_TYPE>\n";
			xml += "</MEDIA_TYPE_GROUP>\n";
			xml += "</TERMINAL>\n";
		
			xml += "</TERMINAL_GROUP>\n";
			xml += "</PROFILE>";
		}
		
		return xml;
	}
	
	
	/**
	 * Pour generer le fichier de profil a envoyer au serveur de multidiffusion
	 * @param destinataires un vecteur de destinataires de type Student
	 * @return l'ensemble des fichiers  envoyer
	 */
	private Vector createSmsProfileFile(Vector destinataires) {
		
		Vector profilEnvois = new Vector();
		
		int nbDestMax = 500;
		int nbDest = destinataires.size();
		
		// on compte le nombre de fichiers a generer et a envoyer		
		int nbFichiers = nbDest/nbDestMax;
		if ((nbDest%nbDestMax)>0) 
			nbFichiers += 1;
		
		// on parcourt tous les fichiers
		for (int i=0; i<nbFichiers; i++) {			
			
			// on genere le XML
			String xml = "";
			
			xml += "<?xml version=\"1.0\" ?>\n" + "\n";				
			xml += "<PROFILE_LIST>\n";
			
			// on parcourt tous les destinataires
			for (int j=i*nbDestMax; j<(i+1)*nbDestMax && j<nbDest; j++) {		
				Etudiant etudiant = (Etudiant)destinataires.elementAt(j);
				xml += this.createProfileDest(etudiant.getName(), "ID_"+j, etudiant.getPhone());
			}			
			
			xml += "</PROFILE_LIST>";
			
			// le profil
			profilEnvois.addElement(xml);						
		}
		
		return profilEnvois;
		
	}
	
	
	
	/**
	 * Envoie le SMS et passe en mode resultat
	 * @param destinataires les destinataires du message
	 * @return le nombre de messages envoyes
	 * @throws ExceptionServeurSmsIndisponible
	 * @throws ExceptionConfirmationEnvoiSms
	 * @throws ExceptionParametresEnvoiSms
	 * @throws ExceptionConfigurationCanal
	 */
	public int sendMessage(Vector destinataires) throws ExceptionServeurSmsIndisponible, ExceptionConfirmationEnvoiSms, ExceptionParametresEnvoiSms, ExceptionConfigurationCanal {	
		
		// je genere les fichiers profil
		Vector profilEnvois = createSmsProfileFile(destinataires);
		
		// nombre d'etudiants concernes
		int nombreSms = 0;
		for (int i=0; i<destinataires.size(); i++) {
			Etudiant s = (Etudiant)destinataires.elementAt(i);
			if (s.getPhone()!=null)
				nombreSms++;
		}
		
		if (log.isDebugEnabled()){
			log.debug("sendMessage: Nouveau message: profil de destinaire cree");
		}	
		
		// pour chaque fichier a envoyer
		for (int indexFichiers=0; indexFichiers<profilEnvois.size(); indexFichiers++) {

			// le profil a traiter
			String profil = (String)profilEnvois.elementAt(indexFichiers);
			
			// 	je poste sur le serveur
			try {        	
				if (log.isDebugEnabled()){
					log.debug("sendMessage: Nouveau message");
				}	
								
				String resumeContent = ParseProprietesCanal.getInstance().getSmsFrom()+" "+this.nomExpediteur+": "+this.sujet+". "+this.message;
				
		    	//String custId = "VV317713";
		    	
		    	//String strategy = "normal";
		    	String to = "students";
		    	
		    	id = conn.send(custId, strategy, this.nomExpediteur, to, ParseProprietesCanal.getInstance().getSmsFromActivation(), this.sujet, this.message, resumeContent, profil);
		    	
				
		    	// le retour du serveur				
				
				//System.out.println("Server response is: ");
				if (log.isDebugEnabled()){
					log.debug("sendMessage: Reponse du serveur");
				}	
				
				if (log.isDebugEnabled()){
					log.debug("sendMessage: ID= "+id);
				}	
			}
			catch(RemoteException e) {
				//e.printStackTrace();
				log.error("sendMessage: "+e);
				
				// on propage une nouvelle exception
				throw new ExceptionServeurSmsIndisponible();
			}    
			log.info("sendMessage: Message bien envoy");
		}
		
		return nombreSms;
	}
	
	
	
}
