/*
 * Cree le 11 oct. 2004
 *
 * par cbissler
 * Centre de Ressources Informatiques 
 * Universit Henri Poincar 
 */
package org.esupportail.portal.channels.CSignet2.actions;


import org.esupportail.portal.channels.CSignet2.beans.Folder;
import org.esupportail.portal.channels.CSignet2.data.DataControler;
import org.esupportail.portal.channels.CSignet2.data.DataException;
import org.esupportail.portal.utils.channels.FrameWorkException;
import org.esupportail.portal.utils.channels.MainChannel;
import org.esupportail.portal.utils.channels.plugins.Message;
import org.esupportail.portal.utils.channels.plugins.MessageBean;
import org.jasig.portal.ChannelRuntimeData;
import org.jasig.portal.PortalException;

/**
 * ModifyFolder<br>
 * <br>
 * Action de modification d'un rpertoire
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:celine.bissler@uhp-nancy.fr">Cline Bissler</a>
 * @version 1.1 
 */
public class ModifyFolder extends SignetAction {
    
    int id_fold;
    Folder folder=null;
   /**
    * Constructeur
    * @param mainchannel Channel principale
    */
    public ModifyFolder(MainChannel mainchannel){
        super(mainchannel);
    }
    /**
     * Init par dfaut qui lance le formulaire de modification
     */
    public Boolean init(ChannelRuntimeData rd) throws PortalException, FrameWorkException {
    	if (log.isDebugEnabled()) log.debug("CSignet2 - ModifyFolder::init()");
    	runtimeData = rd;
    	
    	paramAction();
    	
		id_fold= Integer.parseInt(runtimeData.getParameter("id_fold"));
		
    	DataControler data = new DataControler();
    	
    	try {
            folder=data.getFolder(id_fold);
        } catch (DataException e) {
            log.error("CSignet2 - ModifyFolder::Init() : Erreur d'acc\u00E8s \u00E0 la page");
    		Message.message(mainChannel, runtimeData, new MessageBean("Erreur d'acc\u00E8s \u00E0 la page"), "default");		
    		return Boolean.FALSE;
        }
    	
    	return Boolean.TRUE;
    }
    /**
     * Init de modification d'un folder
     * @param rd Le RuntimeData
     * @return Boolean.TRUE si l'action s'est bien passe, Boolean.FALSE sinon
     * @throws PortalException
     * @throws FrameWorkException
     */
    public Boolean modFolderInit(ChannelRuntimeData rd) throws PortalException, FrameWorkException {
    	if (log.isDebugEnabled()) log.debug("CSignet2 - ModifyFolder::modFolderInit()");
    	runtimeData = rd;
    	paramAction();
    
    	// Rcupration bouton
    	String button = runtimeData.getParameter("butmodifier");
    	
    	// Clic sur le bouton Annuler
    	if(button == null) {
    	    retourAccueil(runtimeData);
    		return Boolean.FALSE;
    	}
    	
    	// Rcupration paramtres
    	String description = runtimeData.getParameter("description");
    	String titre = runtimeData.getParameter("titre");
    	
    	// Tentative d'accs sans paramtres
    	if(titre == null) {
    		log.error( "CSignet2 - CreateFolder::modFolderInit() : Erreur d'acc\u00E8s \u00E0 la page");
    		Message.message(mainChannel, runtimeData, new MessageBean("Erreur d'acc\u00E8s \u00E0 la page"), "default");		
    		return Boolean.FALSE;
    	}
    	
    	// Rcupration IDataReadManager
    	DataControler data = new DataControler();
    	
    	folder.setDescription(description);
    	folder.setTitle(titre);
    	
    	try {
            data.modifyFolder(folder);
        } catch (DataException e) {
            log.error("CSignet2 - ModifyFolder::modFolderInit()dans catch");
            Message.message(mainChannel, runtimeData, new MessageBean(e.getMessage()), "ModifyFolder");
            return Boolean.FALSE;
        }
        retourAccueil(runtimeData);
    	return Boolean.FALSE;
    }
    /**
     * Cre le XML correspondant
     */
    public Boolean setXML() {
    	if (log.isDebugEnabled()) log.debug("CSignet2 - ModifyFolder::setXML()");
    	StringBuffer xml = new StringBuffer();
    	
    	xml=paramXML(xml);
    	
    	xml.append("<folder id=\""+folder.getId()+"\" " );
    	xml.append("titre=\""+folder.getTitle()+"\" ");
    	xml.append("desc=\""+folder.getDescription()+"\"/>");
    	
    	this.xml = xml.toString();
    	
    	return Boolean.TRUE;
    }

    }
