/*
 * Cree le 26 oct. 2004
 *
 * par cbissler
 * Centre de Ressources Informatiques 
 * Universit Henri Poincar 
 */
package org.esupportail.portal.channels.CSignet2.actions;

import java.io.FileNotFoundException;
import java.io.IOException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.esupportail.portal.channels.CSignet2.beans.Folder;
import org.esupportail.portal.channels.CSignet2.data.DataControler;
import org.esupportail.portal.channels.CSignet2.data.DataException;
import org.esupportail.portal.channels.CSignet2.interpreter.IEInterpreter;
import org.esupportail.portal.channels.CSignet2.interpreter.Interpreter;
import org.esupportail.portal.channels.CSignet2.interpreter.MalFormeException;
import org.esupportail.portal.channels.CSignet2.interpreter.NSInterpreter;
import org.esupportail.portal.channels.CSignet2.interpreter.OperaInterpreter;
import org.esupportail.portal.channels.CSignet2.interpreter.XBELInterpreter;
import org.esupportail.portal.channels.CSignet2.storage.SizeLimitException;
import org.esupportail.portal.channels.CSignet2.storage.UploadWorker;
import org.esupportail.portal.utils.channels.FrameWorkException;
import org.esupportail.portal.utils.channels.MainChannel;
import org.esupportail.portal.utils.channels.plugins.Message;
import org.esupportail.portal.utils.channels.plugins.MessageBean;
import org.jasig.portal.ChannelRuntimeData;
import org.jasig.portal.PortalException;
import org.xml.sax.SAXException;

/**
 * UploadXBEL<br>
 * <br>
 * Action qui consiste  charger le XBEL
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:celine.bissler@uhp-nancy.fr">Cline Bissler</a>
 * @version 1.1 
 */
public class Upload extends SignetAction{
    protected static final Log log = LogFactory.getLog(DataControler.class);
    
    Folder ajout=null;
    /**
     * Constructeur
     * @param mainchannel
     */
     public Upload(MainChannel mainchannel){
        super(mainchannel);
    }
    /**
     * Charge l'arobrescence de la personne connecte
     */
    public Boolean init(ChannelRuntimeData rd) throws PortalException, FrameWorkException {
		if (log.isDebugEnabled()) log.debug("CSignet2 - Upload::init()");
		runtimeData = rd;
		
		paramAction();
		root=new Folder();
		DataControler cd=new DataControler();
	    try {
             root=cd.RecupererArbrePerso(login);
             xmlroot=root.toXMLComplet();
        } catch (DataException e) {
            if (log.isDebugEnabled()) log.debug( "CSignet2 - Principal::init() : Erreur d'acc\u00E8s \u00E0 la page "+e.getMessage());
            Message.message(mainChannel, runtimeData, new MessageBean(e.getMessage()), "default");		
        	return Boolean.FALSE;
        }
		
		return Boolean.TRUE;
	}
    /**
     * Interprete le fichier en fonction du navigateur
     * @param rd Le RuntimeData
     * @return Boolean.TRUE si l'action s'est bien passe, Boolean.FALSE sinon
     * @throws PortalException
     * @throws FrameWorkException
     */
    public Boolean initView(ChannelRuntimeData rd) throws PortalException, FrameWorkException {
        if (log.isDebugEnabled()) log.debug("CSignet2 - Upload::initView()");
		runtimeData = rd;
		
		paramAction();
		// Rcupration bouton
		String button = runtimeData.getParameter("butcreer");
		// Clic sur le bouton Annuler
		if(button == null) {
		    retourAccueil(runtimeData);
			return Boolean.FALSE;
		}
		String type = runtimeData.getParameter("type");
		if(type == null) {
		    log.error("CSignet2 - Upload::initView() : Erreur d'acc\u00E8s \u00E0 la page");
			Message.message(mainChannel, runtimeData, new MessageBean("Erreur d'acc\u00E8s \u00E0 la page"), "defaultModif");		
			return Boolean.FALSE;
		}
		UploadWorker worker = new UploadWorker(runtimeData);
		try {
			worker.parseFile("file");
			if (log.isDebugEnabled()) log.debug("LECTURE fichier : "+worker.getName());
			Interpreter ixb=null;
			if (type.equals("IE")){
			    ixb=new IEInterpreter(login);
			}
			else if(type.equals("NS")){
			    ixb=new NSInterpreter(login);
			}
			else if(type.equals("OP")){
			    ixb=new OperaInterpreter(login);
			}
			else if(type.equals("XBEL")){
			    ixb=new XBELInterpreter(login);
			}
			ajout=ixb.interpreter(worker.getInputStream());
			
		}
		catch(SAXException e) {
		    String msg=e.getMessage().replaceAll("\"","&#34;");
			msg=msg.replaceAll("<","&#60;");
			msg=msg.replaceAll(">","&#62;");
			if (log.isDebugEnabled()) log.debug("CSignet2 - Upload::initView() : Erreur de syntaxe : "+msg);
			Message.message(mainChannel, runtimeData, new MessageBean("Erreur de syntaxe : "+msg), "uploadFile");
			return Boolean.FALSE;
		}
		catch(SizeLimitException e) {
		    if (log.isDebugEnabled()) log.debug("CSignet2 - Upload::initView() : Taille de fichier trop importante");
			Message.message(mainChannel, runtimeData, new MessageBean("Le fichier joint est trop gros"), "uploadFile");
			return Boolean.FALSE;
		}
		catch(FileNotFoundException e) {
		    if (log.isDebugEnabled()) log.debug("CSignet2 - Upload::initView() : Aucun fichier attach\u00E9");
			Message.message(mainChannel, runtimeData, new MessageBean("Le fichier joint est manquant"), "uploadFile");
			return Boolean.FALSE;
		}
		catch(IOException e) {
		    if (log.isDebugEnabled()) log.debug("CSignet2 - Upload::initView() : Impossible d'ouvrir le fichier");
			Message.message(mainChannel, runtimeData, new MessageBean("Impossible d ouvrir le fichier"), "uploadFile");
			return Boolean.FALSE;
		}
		catch(MalFormeException e) {
		    String msg=e.getMessage().replaceAll("\"","&#34;");
			msg=msg.replaceAll("<","&#60;");
			msg=msg.replaceAll(">","&#62;");
			if (log.isDebugEnabled()) log.debug("CSignet2 - Upload::initView() : Erreur de syntaxe : "+msg);
			Message.message(mainChannel, runtimeData, new MessageBean("Erreur de syntaxe : "+msg), "uploadFile");
			return Boolean.FALSE;
		}
				return Boolean.TRUE;
	}
    /**
     * Action qui sauve les signets chargs
     * @param rd
     * @return
     * @throws PortalException
     * @throws FrameWorkException
     */
    public Boolean initSave(ChannelRuntimeData rd) throws PortalException, FrameWorkException {
        if (log.isDebugEnabled()) log.debug("CSignet2 - Upload::initSave()");
		runtimeData = rd;
		
		paramAction();
		// Rcupration bouton
		String button = runtimeData.getParameter("butsave");

		// Clic sur le bouton Annuler
		if(button == null) {
		    retourAccueil(runtimeData);
			return Boolean.FALSE;
		}
		
		DataControler dc=new DataControler();
		
		try {
		    ajout.setParent(root.getId());
		    if (log.isDebugEnabled()) log.debug("CSignet2 - Upload::initSave()33 on ENREGISTRE");
            dc.enregisterArbre(ajout);
           
        } catch (DataException e) {
            if (log.isDebugEnabled()) log.debug("CSignet2 - Upload::initSave() erreur lors de l'enregistrement de l arborescence");
            Message.message(mainChannel, runtimeData, new MessageBean("Erreur lors de l'enregistrement de l'arborescence."+e.getMessage()), "uploadFile");
            return Boolean.FALSE;
        }
				
        retourAccueil(runtimeData);
        
		return Boolean.FALSE;
	}
    /**
     * Cre le XML correspondant
     */
    public Boolean setXML() {
        if (log.isDebugEnabled()) log.debug("CSignet2 - Upload::setXML()");
		StringBuffer xml = new StringBuffer();
		if(ajout!=null)
		    xml=paramXML(xml);
				
		if(ajout!=null)
		     xml.append(ajout.toXMLComplet());
		
		this.xml = xml.toString();
		this.xml=this.xml.replaceAll("&","&amp;");
		addDownloadXslParameter();
		if (log.isDebugEnabled()) log.debug("CSignet2 - Upload::setXML() FIN" );
		return Boolean.TRUE;
	}
}
