package org.esupportail.portal.channels.CSignet2.config;


import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import org.esupportail.portal.channels.CSignet2.actions.SignetAction;
import org.esupportail.portal.utils.channels.ConfigChannel;


/**
 * Config<br>
 * <br>
 * Classe implmentant un mcanisme de singleton permettant la lecture du fichier<br>
 * de configuration du canal des signets<br>
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:celine.bissler@uhp-nancy.fr">Cline Bissler</a>
 * @version 1.1 
 */

public class Config extends ConfigChannel {

	private static Config singleton = null;
	private String sizeUpload;
	private String useicon;

	 protected static final Log log = LogFactory.getLog(SignetAction.class);
	   
	/**
	 * Rcupration du singleton
	 * @return
	 */
	public static Config getInstance() {
		if(singleton == null) {
			singleton = new Config();
		}
		return singleton;
	}
	
	/**
	 * Le fichier de configuration
	 * @return
	 */
	protected String getConfigFile() {
		return "/properties/channels/org_esup/CSignet2/CSignet2.xml";
	}
	
	/**
	 * Mthode permettant la lecture de la partie spcifique<br>
	 * au canal des signets du fichier de configuration
	 */
	protected void customDigester() {
		if (log.isDebugEnabled()) log.debug("CSignet2 - Config::customDigester()");
		dig.addCallMethod("config/fileupload", "setSizeUpload", 1);
		dig.addCallParam("config/fileupload", 0, "size");
		dig.addCallMethod("config/useicon", "setUseicon", 1);
		dig.addCallParam("config/useicon", 0, "value");
	}
	/**
	 * La taille limite des fichiers uploads en octets
	 * @param size
	 */
	public void setSizeUpload(String size) {
		sizeUpload = size;
	}

	/**
	 * La taille limite des fichiers uploads en octets
	 * @return
	 */
	public int getSizeUpload() {
		return new Integer(sizeUpload).intValue();
	}
	/**
	 * La taille limite des fichiers uploads en octets
	 * @param size
	 */
	public void setUseicon(String val) {
		useicon = val;
	}

	/**
	 * La taille limite des fichiers uploads en octets
	 * @return
	 */
	public String getUseicon() {
		return useicon;
	}

}
