/*
 * Cree le 5 nov. 2004
 *
 * TODO 
 * par cbissler
 * Centre de Ressources Informatiques 
 * Universit Henri Poincar 
 */
package org.esupportail.portal.channels.CSignet2.interpreter;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Vector;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.esupportail.portal.channels.CSignet2.beans.BookMark;
import org.esupportail.portal.channels.CSignet2.beans.Folder;
import org.esupportail.portal.channels.CSignet2.data.DataControler;
import org.esupportail.portal.channels.CSignet2.utils.CaracteresSpeciaux;

import org.xml.sax.SAXException;

/**
 * NSInterpreter<br>
 * <br>
 * 
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:celine.bissler@uhp-nancy.fr">Cline Bissler</a>
 * @version 1.1 
 */
public class NSInterpreter implements Interpreter {
    protected static final Log log = LogFactory.getLog(DataControler.class);
    
    private String login=null;
    private String ligne_courante=null;
    private int num_ligne=0;
    private BufferedReader r=null;
    
    private int SYNT_FOLDER=1;
    private int SYNT_BOOKMARK=2;
    private int SYNT_DL=3;
    private int SYNT_FIN_DL=4;
    private int SYNT_NULL=5;
    
    private CaracteresSpeciaux carac;
    /**
     * Constructeur
     * @param input Le flux XML
     * @param login Le login de l'utilisateur
     */
    public NSInterpreter(String login) {
        carac=new CaracteresSpeciaux();
        this.login=login;
   }
   
    /**
     * Interprete le document xml et retourne l'arborescence : 
     * le Folder root 
     * @return Le Folder root de l'arborescence  ajouter
     */
    public Folder interpreter(InputStream input) throws MalFormeException,IOException{
        Folder f= new Folder();
        f.setTitle("Chargement Netscape/Mozilla/Firefox");
        Calendar d=Calendar.getInstance();
       
        f.setDescription("Chargement Netscape/Mozilla/Firefox le : "+d.get(Calendar.DAY_OF_MONTH)+" - "+d.get(Calendar.MONTH)+" - "+d.get(Calendar.YEAR));
        
        if (log.isDebugEnabled()) log.debug("ici 1");
        Reader br = new InputStreamReader(input,"UTF-8");//"UTF-8"
        if (log.isDebugEnabled()) log.debug("ici 2");
        r=new BufferedReader(br);
        if (log.isDebugEnabled()) log.debug("ici 3");
        ligne_courante="";
        int i=1;
        int code=SYNT_NULL;
        while ((ligne_courante!=null)&&(code!=SYNT_FIN_DL)){
            code=LireLigne();
            if (code==SYNT_FOLDER)
            {
                f.addSubFolder(interpreterFolder(i));
                i++;
            }
            if (code==SYNT_BOOKMARK)
            {
               f.addBookMark(interpreterBookmark(i));
                i++;
            }
            
        }
        	
        br.close();
       
        return f;
    }
    
    private int LireLigne()throws IOException{
        ligne_courante = r.readLine();
        num_ligne++;
        if (ligne_courante!=null){
	        if (ligne_courante.indexOf("<H3 ")!=-1)
	            return SYNT_FOLDER;
	        else if (ligne_courante.indexOf("<A HREF=")!=-1)
	            return SYNT_BOOKMARK;
	        else if (ligne_courante.indexOf("<DL>")!=-1)
	            return SYNT_DL;
	        else if (ligne_courante.indexOf("</DL>")!=-1)
	            return SYNT_FIN_DL;
	        else
	            return SYNT_NULL;
        }
    else
        return SYNT_NULL;
    }
    
    /**
     * Interprte un rpertoire 
     * @param el Element XML
     * @param ordre Ordre dans lequel il est trouv de dans lequel il apparatra dans l'arborescence
     * @return Le Folder correspondant
     */
    private Folder interpreterFolder(int ordre) throws MalFormeException,IOException{
        if (log.isDebugEnabled()) log.debug("CSignet2 - IEInterpreter::interpreterFolder()");
        Folder f=new Folder();
          
        Collection les_book=new Vector();
        Collection les_fold=new Vector();
        
        f.setB_modif(true);
        f.setLogin(login);
        f.setId_group("aucun");
        f.setB_root(false);
        f.setOrder(ordre);
        Date d=new Date();
        f.setTitle(getTitreFolder());
       // f.setDescription("Chargement NS le : "+d.toString());
        if ((f.getTitle()==null)||(f.getTitle().compareTo("")==0)){
        	log.info("Il n'y pas de titre de dossier "+ligne_courante);
            throw new MalFormeException("Il n'y pas de titre de dossier - ligne n "+num_ligne+" : "+ligne_courante);
        }
  
        int i=1;
        int code=SYNT_NULL;
        while (code!=SYNT_FIN_DL){
            code=LireLigne();
            if (code==SYNT_FOLDER)
            {
                f.addSubFolder(interpreterFolder(i));
                i++;
            }
            if (code==SYNT_BOOKMARK)
            {
                f.addBookMark(interpreterBookmark(i));
                i++;
            }
            
        }
        f.setTitle(carac.convertirCaracXML(f.getTitle()));
                
      return f;
      
    }
    /**
     * Interprte un bookmark
     * @param el Element XML
     * @param ordre Ordre dans lequel il est trouv de dans lequel il apparatra dans l'arborescence
     * @return Le BookMark correspondant
     */
    private BookMark interpreterBookmark(int ordre)throws MalFormeException{
        if (log.isDebugEnabled()) log.debug("CSignet2 - IEInterpreter::interpreterBookmark()");
        
        BookMark f=new BookMark();
        
        f.setB_modif(true);
        f.setLogin(login);
        f.setId_group("aucun");
        f.setB_root(false);
        f.setOrder(ordre);
        Date d=new Date();
     //   f.setDescription("Chargement XBEL le : "+d.toString());
        f.setTitle(getTitreBookMark());
        f.setUrl(getUrlBookMark());
        if ((f.getTitle()==null)||(f.getTitle().compareTo("")==0)){
        	log.info("Il n'y pas de titre au Signet "+ligne_courante);
            throw new MalFormeException("Il n'y pas de titre au Signet - ligne n "+num_ligne+" : "+ligne_courante);
        }
        if ((f.getUrl()==null)||(f.getUrl().compareTo("")==0)){
        	log.info("Il n'y pas d'URL au Signet "+ligne_courante);
            throw new MalFormeException("Il n'y pas d'URL au Signet - ligne n "+num_ligne+" : "+ligne_courante);
        }
        f.setTitle(carac.convertirCaracXML(f.getTitle()));
        f.setUrl(carac.convertirCaracXMLURL(f.getUrl()));
        
        return f;
    }
    private String getTitreFolder()throws MalFormeException{
        int deb=ligne_courante.indexOf(">",ligne_courante.indexOf("<H3 "));
        int fin=ligne_courante.indexOf("</H3>");
        String titre=ligne_courante.substring(deb+1,fin);
                
        titre=carac.convertirAccentue(titre);
       
        return titre;
    }
    private String getTitreBookMark()throws MalFormeException{
        int deb=ligne_courante.indexOf(">",ligne_courante.indexOf("<A HREF=\""));
        int fin=ligne_courante.indexOf("</A>");
        String titre=ligne_courante.substring(deb+1,fin);
       
        CaracteresSpeciaux carac=new CaracteresSpeciaux();
        titre=carac.convertirAccentue(titre);
        
        return titre;
    }
    private String getUrlBookMark()throws MalFormeException{
        int deb=ligne_courante.indexOf("<A HREF=\"");
        int fin=ligne_courante.indexOf("\"",ligne_courante.indexOf("<A HREF=\"")+9);
        String url=ligne_courante.substring(deb+9,fin);
        
        return url;
    }
}