/*
 * Cree le 26 oct. 2004
 *
 * par cbissler
 * Centre de Ressources Informatiques 
 * Universit Henri Poincar 
 */
package org.esupportail.portal.channels.CSignet2.storage;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

import org.esupportail.portal.channels.CSignet2.config.*;

import org.jasig.portal.ChannelRuntimeData;
import org.jasig.portal.MultipartDataSource;

/**
 * UploadWorker<br>
 * <br>
 * Classe charge de l'upload de fichier
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:celine.bissler@uhp-nancy.fr">Cline Bissler</a>
 * @version 1.1 
 */
public class UploadWorker {

	private ChannelRuntimeData runtimeData = null;
	private MultipartDataSource mps = null;
	private int size = -1;
	private File file=null;
	/**
	 * Constructeur
	 * @param rd Les ChannelRuntimeData contenant le fichier upload
	 */
	public UploadWorker(ChannelRuntimeData rd) {
		runtimeData = rd;
	}
	
	/**
	 * Dclenche la rcupration du fichier
	 * @param parameter Le nom du paramtre contenant le fichier upload
	 * @throws SizeLimitException
	 * @throws FileNotFoundException
	 */
	public void parseFile(String parameter) throws SizeLimitException, FileNotFoundException {
		Object file2 = runtimeData.getObjectParameter(parameter);
		if(file2 == null) {
		   throw new FileNotFoundException();
		}
		mps = (MultipartDataSource)file2;
		
		InputStream stream = null;
		try {
		   stream = mps.getInputStream();
		}
		catch(IOException e) {
			throw new FileNotFoundException();
		}
		int filesize = 0;
		try {
			filesize = stream.available();
			stream.close();
		}
		catch(IOException e) {
			throw new FileNotFoundException();
		}
		if(getSize() < filesize) {
			throw new SizeLimitException();
		}
		
	}

	/**
	 * Retourne la taille du fichier upload
	 * @return
	 */
	private int getSize() {
	   
	    int r=Config.getInstance().getSizeUpload();
	 
		return r;
	}

	
	/**
	 * Retourne le type MIME du fichier upload
	 * @return
	 */	
	public String getContentType() {
		return mps.getContentType();
	}
	
	/**
	 * Retourne le nom du fichier upload
	 * @return
	 */
	public String getName() {
		return mps.getName();
	}
	
	/**
	 * Retourne un flux de lecture sur le fichier upload
	 * @return
	 * @throws IOException
	 */
	public InputStream getInputStream() throws IOException {
		return mps.getInputStream();
	}
    /**
     * @return Retourne le file.
     */
    public File getFile() {
        return file;
    }
    /**
     * @param file Le file  positionner.
     */
    public void setFile(File file) {
        this.file = file;
    }
}
