<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

<xsl:output method="html" indent="no" />

<xsl:param name="baseActionURL" />
<xsl:param name="prefForm" />
<xsl:param name="mediaPath" />


<!--#####################################################-->
<!--                                                     -->                       
<!--                    Barre d'outils                   -->
<!--                                                     -->
<!--#####################################################-->
<xsl:template name="barre.outil">
	<table border="0" align="left" cellspacing="0" cellpadding="0">
	<tr class="uportal-background-dark">
		
		<td><table border="0"><tr><td>&#160;&#160;
			<a class="navigation" href="{$baseActionURL}?action=CreateBookMark&amp;id_folder_courant={./id_folder_courant/@id}">
				<xsl:call-template name="icon.addBookMark" />
			</a>&#160;</td><td><a class="navigation" href="{$baseActionURL}?action=CreateBookMark&amp;id_folder_courant={./id_folder_courant/@id}">
			Ajouter un signet</a></td></tr></table><!--<div class="uportal-text-reversed">-->
		
		</td>
		<td><table border="0"><tr><td>&#160;&#160;
			<a class="navigation" href="{$baseActionURL}?action=CreateFolder&amp;id_folder_courant={./id_folder_courant/@id}">
				<xsl:call-template name="icon.addFolder" />
			</a>&#160;</td><td><a class="navigation" href="{$baseActionURL}?action=CreateFolder&amp;id_folder_courant={./id_folder_courant/@id}">
			Ajouter un dossier</a></td></tr></table>
		</td>
		<td>
			<xsl:choose>
				<xsl:when test="./id_book_courant/@id!=0"><!--si il y a un book courant-->
					<table border="0"><tr><td>&#160;&#160;
					<a class="navigation" href="{$baseActionURL}?action=couper&amp;id_folder_courant={./id_folder_courant/@id}&amp;id_element_copy={./id_book_courant/@id}">
						<xsl:call-template name="icon.couper" />
					</a>&#160;</td><td><a class="navigation" href="{$baseActionURL}?action=couper&amp;id_folder_courant={./id_folder_courant/@id}&amp;id_element_copy={./id_book_courant/@id}">
			Couper</a></td></tr></table>
				</xsl:when>
				<xsl:otherwise><!--si il s agit d'un folder courant-->
					<table border="0"><tr><td>&#160;&#160;
					<a class="navigation" href="{$baseActionURL}?action=couper&amp;id_folder_courant={./id_folder_courant/@id}&amp;id_element_copy={./id_folder_courant/@id}">
						<xsl:call-template name="icon.couper" />
					</a>&#160;</td><td><a class="navigation" href="{$baseActionURL}?action=couper&amp;id_folder_courant={./id_folder_courant/@id}&amp;id_element_copy={./id_folder_courant/@id}">
			Couper</a></td></tr></table>
				</xsl:otherwise>
			</xsl:choose>
		</td>
		<td>
			<xsl:choose><!--si element en couper-->
				<xsl:when test="./id_elements_copy"><table border="0"><tr><td>&#160;&#160;
					<a class="navigation" href="{$baseActionURL}?action=coller&amp;id_folder_courant={./id_folder_courant/@id}">
						<xsl:call-template name="icon.coller" />
					</a>&#160;</td><td><a class="navigation" href="{$baseActionURL}?action=coller&amp;id_folder_courant={./id_folder_courant/@id}">
			Coller tout</a></td></tr></table>
				</xsl:when>
			</xsl:choose>
		</td>
		<td><table border="0"><tr><td>&#160;&#160;
			<a href="{$baseActionURL}?action=uploadFile&amp;id_folder_courant={./id_folder_courant/@id}">
				<xsl:call-template name="icon.addFile" />
			</a>&#160;</td><td><a class="navigation" href="{$baseActionURL}?action=uploadFile&amp;id_folder_courant={./id_folder_courant/@id}">
			Import / Export</a></td></tr></table>
		</td>
		<td><table border="0"><tr><td>&#160;&#160;
			<a class="navigation" href="{$baseActionURL}?action=default&amp;id_folder_courant={./id_folder_courant/@id}">
				<xsl:call-template name="icon.swap2" />
			</a>&#160;</td><td><a class="navigation" href="{$baseActionURL}?action=default&amp;id_folder_courant={./id_folder_courant/@id}">
			Mode Navigation</a></td></tr></table>
		</td>	
	</tr>
	
	</table>
</xsl:template>
<!--#####################################################-->
<!--                                                     -->                       
<!--                    Barre d'outils Vue               -->
<!--                                                     -->
<!--#####################################################-->
<xsl:template name="barre.outil.vue">
	<table border="0" align="left" cellspacing="0" cellpadding="0">
	<tr class="uportal-background-dark">
		
		<td><table border="0"><tr><td>&#160;&#160;
			<a class="navigation" href="{$baseActionURL}?action=defaultModif&amp;id_folder_courant={./id_folder_courant/@id}">
				<xsl:call-template name="icon.swap" />
			</a>&#160;</td><td><a class="navigation" href="{$baseActionURL}?action=defaultModif&amp;id_folder_courant={./id_folder_courant/@id}">
			Mode Modification</a></td></tr></table><!--<div class="uportal-text-reversed">-->
		</td>	
	</tr>
	</table>
</xsl:template>
<!--#####################################################-->
<!--                                                     -->                       
<!--                    Les Icones                       -->
<!--                                                     -->
<!--#####################################################-->
<xsl:template name="icon.folder.ferme">
	<div align="center" valign="absmiddle">
		<a href="{$baseActionURL}?action=defaultview&amp;id={./@id}&amp;id_folder_courant={./@id}&amp;id_book_courant=0#[{./@id}]">
			<img src="{$mediaPath}Browse 4.gif" border="0" alt="Repertoire ferme" />
		</a>
	</div>
</xsl:template>
<xsl:template name="icon.folder.ouvert">
	<div align="center" valign="absmiddle">
		<a href="{$baseActionURL}?action=defaultview&amp;id={./@id}&amp;id_folder_courant={./@id}&amp;id_book_courant=0#[{./@id}]">
			<img src="{$mediaPath}Folder Yellow1.gif" border="0" alt="Repertoire ouvert" />
		</a>
	</div>
</xsl:template>
<xsl:template name="icon.bookmark">
	<div align="center" valign="absmiddle">
		<a href="{$baseActionURL}?action=defaultview&amp;id={./@id}&amp;id_folder_courant={../@id}&amp;id_book_courant={./@id}&amp;title_book_courant={./title}#[{./@id}]">
			<img src="{$mediaPath}Bookmarks 3c.gif" border="0" alt="Bookmark" />
		</a>
	</div>
</xsl:template>

<xsl:template name="icon.folder.ferme.vue">
	<div align="center" valign="absmiddle">
		<a href="{$baseActionURL}?action=defaultvue&amp;id={./@id}&amp;id_folder_courant={./@id}&amp;id_book_courant=0#[{./@id}]">
			<img src="{$mediaPath}Browse 4.gif" border="0" alt="Repertoire ferme" />
		</a>
	</div>
</xsl:template>
<xsl:template name="icon.folder.ouvert.vue">
	<div align="center" valign="absmiddle">
		<a href="{$baseActionURL}?action=defaultvue&amp;id={./@id}&amp;id_folder_courant={./@id}&amp;id_book_courant=0#[{./@id}]">
			<img src="{$mediaPath}Folder Yellow1.gif" border="0" alt="Repertoire ouvert" />
		</a>
	</div>
</xsl:template>
<xsl:template name="icon.bookmark.vue">
	<div align="center" valign="absmiddle">
		<a href="{$baseActionURL}?action=defaultvue&amp;id={./@id}&amp;id_folder_courant={/xml/id_folder_courant/@id}&amp;id_book_courant={./@id}&amp;title_book_courant={./title}#[{./@id}]">
			<img src="{$mediaPath}Bookmarks 3c.gif" border="0" alt="Bookmark" />
		</a>
	</div>
</xsl:template>
<xsl:template name="icon.fold">
		<img src="{$mediaPath}Browse 4.gif" border="0" alt="signet" />
</xsl:template>
<xsl:template name="icon.book">
		<img src="{$mediaPath}Bookmarks 3c.gif" border="0" alt="repertoire" />
</xsl:template>

<xsl:template name="icon.swap">
		<img src="{$mediaPath}Themes 3.gif" border="0" alt="Passer en mode modification" />
</xsl:template>
<xsl:template name="icon.swap2">
		<img src="{$mediaPath}Search1.gif" border="0" alt="Passer en mode navigation" />
</xsl:template>

<xsl:template name="icon.addBookMark">
		<img src="{$mediaPath}Add Bookmark1.gif" border="0" alt="Ajouter un signet" />
</xsl:template>
<xsl:template name="icon.addFolder">
		<img src="{$mediaPath}Add Folder1.gif" border="0" alt="Ajouter un dossier" />
</xsl:template>
<xsl:template name="icon.couper">
		<img src="{$mediaPath}Cut1.gif" border="0" alt="couper" />
</xsl:template>
<xsl:template name="icon.coller">
		<img src="{$mediaPath}Paste1.gif" border="0" alt="coller" />
</xsl:template>
<xsl:template name="icon.addFile">
		<img src="{$mediaPath}Stuff 2.gif" border="0" alt="Charger un XBEL" />
</xsl:template>

<xsl:template name="icon.supcopie">
	<div valign="absmiddle" align="center">
		<img src="{$mediaPath}Delete1.gif" border="0" alt="supprimer" />
	</div>
</xsl:template>

<xsl:template name="icon.pcut">
	<div align="center" valign="absmiddle">
		<xsl:choose>
			<xsl:when test="/xml/useicon[@val='vrai']">
		<img src="{$mediaPath}Cut1.gif" border="0" alt="couper" />
		</xsl:when>
		<xsl:otherwise>[Couper]</xsl:otherwise></xsl:choose>
	</div>
</xsl:template>
<xsl:template name="icon.psup">
	<div align="center" valign="absmiddle">
		<xsl:choose>
			<xsl:when test="/xml/useicon[@val='vrai']">
		<img src="{$mediaPath}Delete1.gif" border="0" alt="supprimer" />
		</xsl:when>
		<xsl:otherwise>[Supprimer]</xsl:otherwise></xsl:choose>
	</div>
</xsl:template>
<xsl:template name="icon.pmod">
	<div align="center" valign="absmiddle">
		<xsl:choose>
			<xsl:when test="/xml/useicon[@val='vrai']">
		<img src="{$mediaPath}Properties1.gif" border="0" alt="modifier" />
	</xsl:when>
		<xsl:otherwise>[Modifier]</xsl:otherwise></xsl:choose>
	</div>
</xsl:template>
<xsl:template name="icon.phaut">
	<div align="center" valign="absmiddle">
		<xsl:choose>
			<xsl:when test="/xml/useicon[@val='vrai']">
		<img src="{$mediaPath}haut1.gif" border="0" alt="monter" />
	</xsl:when>
		<xsl:otherwise>[Monter]</xsl:otherwise></xsl:choose>
	</div>
</xsl:template>
<xsl:template name="icon.pbas">
	<div align="center" valign="absmiddle">
		<xsl:choose>
			<xsl:when test="/xml/useicon[@val='vrai']">
		<img src="{$mediaPath}bas1.gif" border="0" alt="descendre" />
	</xsl:when>
		<xsl:otherwise>[Descendre]</xsl:otherwise></xsl:choose>
	</div>
</xsl:template>



<xsl:template name="icon.adbook">
	<div align="center" valign="absmiddle">
		<img src="{$mediaPath}Address Book2.gif" border="0" alt="carnet" />
	</div>
</xsl:template>
<xsl:template name="icon.alert">
	<div align="center" valign="absmiddle">
		<img src="{$mediaPath}Spell.gif" border="0" alt="Attention" />
	</div>
</xsl:template>

</xsl:stylesheet>