<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:import href="./BookMarkTemplate.xsl" />
<xsl:output method="html" indent="no" />

<xsl:param name="baseActionURL" />
<xsl:param name="prefForm" />
<xsl:param name="mediaPath" />
<xsl:param name="id_folder_courant" />
<!--<xsl:param name="superuser" />
<xsl:param name="all" />-->
<xsl:template match="xml">
	
			
<table border="1" width="100%" cellspacing="0" cellpadding="0">
	<tr>
		<td class="uportal-background-dark"><!-- La barre d outils-->
			<xsl:call-template name="barre.outil" />
		</td>
	</tr>
	<!-- L element en copie-->
	<xsl:apply-templates select="./id_elements_copy"/>
	<!-- Le chemin courant-->
	<tr class="uportal-background-light">
		<td class="uportal-text"><!--class="uportal-label" nowrap="true"-->
			<xsl:apply-templates select="./path"/>
		</td>
	</tr>
	<tr>
		<td>
			<!-- L arbre perso-->
<!--<table border="0" width="100%" cellspacing="0" cellpadding="10">
	-->
			<xsl:call-template name="arbre.perso" />
	

</td>
</tr>
</table>

</xsl:template>	

<!--Affichage de la racine perso et appelle récursif-->
<xsl:template name="arbre.perso">
<table width="100%" border="0" cellpadding="0" cellspacing="0">
	<tr>
		<td nowrap="true" width="70%">
			<table width="100%" border="0" cellpadding="0" cellspacing="0">
				<!--affichage du root-->
				<tr><td>
				<table width="100%" border="0" cellpadding="0" cellspacing="0">
				<tr>
					<td width="21">
						<xsl:call-template name="icon.adbook" />
						
					</td>
					<td class="uportal-label">
						<a href="{$baseActionURL}?action=defaultview&amp;id_folder_courant={./element/@id}&amp;id_book_courant=0">
							<xsl:value-of select="./element/title" />
						</a>
					</td>
					</tr>
				</table>	
				</td></tr>
				<xsl:apply-templates select="./element/element">
					<!--Appel Récursif-->
					<xsl:sort select="./@order" order="ascending" data-type="number" />
				</xsl:apply-templates>
			</table>
		</td>
		<td width="30%">&#160;</td>
	</tr>	
</table>
</xsl:template>


<!--Affichage de l element folder recursif-->
<xsl:template match="element">
	<tr>
		<xsl:variable name='dec'><xsl:value-of select="./@prof * 21" /></xsl:variable>
		<td nowrap="true">
			<table width="100%" border="0" cellpadding="0" cellspacing="0">
				<tr>
					<td width="{$dec}">&#160;
					</td>
					<td width="21">
						<xsl:if test="./@type='book'">
							<xsl:call-template name="icon.bookmark" />
						</xsl:if>
						<xsl:if test="./@type='folder'">
							<xsl:choose><xsl:when test="./@ouvert='vrai'">
								<xsl:call-template name="icon.folder.ouvert" />			
							</xsl:when>
							<xsl:otherwise>
								<xsl:call-template name="icon.folder.ferme" />
							</xsl:otherwise></xsl:choose>
						</xsl:if>
					</td>
					
						<xsl:if test="./@type='folder'">
							<td class="uportal-label" nowrap="true">
									<a href="{$baseActionURL}?action=defaultview&amp;id_folder_courant={./@id}&amp;id_book_courant=0#[{./@id}]">
											<xsl:value-of select="./title" />
										</a><A NAME="[{./@id}]{/xml/id_channel/@val}"/>
							</td>
									<td><div align="right">
										<xsl:call-template name="options.folder" />
										</div>
									</td>
								
						</xsl:if>
						<xsl:if test="./@type='book'">
							<td class="uportal-label" nowrap="true">
									<a href="{$baseActionURL}?action=defaultview&amp;id={./@id}&amp;id_folder_courant={../@id}&amp;id_book_courant={./@id}&amp;title_book_courant={./title}#[{./@id}]">
											<xsl:value-of select="./title" />
										</a>
										<A NAME="[{./@id}]{/xml/id_channel/@val}"/>
									</td>
									<td>
										<div align="right">
									<xsl:call-template name="options.book" />
									</div>
								</td>
						
					</xsl:if>	
							
				<!--<xsl:if test="count(./element)!=0">
					<td>&#160;</td>
				</xsl:if>-->
			</tr>	
		</table>
	</td>
	<!--<td width="100%">&#160;</td>-->
</tr>	
<xsl:apply-templates select="./element">
	<!--Appel Récursif-->
	<xsl:sort select="./@order" order="ascending" data-type="number"/>
</xsl:apply-templates>		
</xsl:template>

<!-- option folder-->
<xsl:template name="options.folder">
	<xsl:variable name='lar'>
	<xsl:choose>
		<xsl:when test="/xml/useicon[@val='vrai']">
			21
		</xsl:when>
		<xsl:otherwise>70
		</xsl:otherwise>
	</xsl:choose>
	</xsl:variable>
	<table border="0">
		<tr>
			<td class="uportal-label" nowrap="true" width="{$lar}">
				<a href="{$baseActionURL}?action=couper&amp;id_folder_courant={./@id}&amp;id_fold={./@id}&amp;id_element_copy={./@id}#[{./@id}]">
					<xsl:call-template name="icon.pcut" />
				</a>
			</td>
			<td class="uportal-label" 
				nowrap="true" width="{$lar}">
				<a 
					href="{$baseActionURL}?action=ModifyFolder&amp;id_folder_courant={./@id}&amp;id_fold={./@id}#[{./@id}]">
					<xsl:call-template 
						name="icon.pmod" />
				</a>
			</td>
			<td class="uportal-label" 
				nowrap="true" width="{$lar}">
				<a 
					href="{$baseActionURL}?action=DeleteFolder&amp;id_folder_courant={../@id}&amp;id_fold={./@id}#[{./@id}]">
					<xsl:call-template 
						name="icon.psup" />
				</a>
			</td>
			<td class="uportal-label" 
				nowrap="true" width="{$lar}">
				<xsl:if test="./@order!=1">
					<a 
						href="{$baseActionURL}?action=bouger&amp;id={./@id}&amp;ordre={./@order}&amp;parent={../@id}&amp;sens=monter#[{./@id}]">
						<xsl:call-template 
							name="icon.phaut" 
							/>
					</a>
				</xsl:if>
				<xsl:if test="./@order=1"> 
					&#160; </xsl:if>
			</td>
			<td class="uportal-label" 
				nowrap="true" width="{$lar}">
				<xsl:if 
					test="position()!=last()">
					<a 
						href="{$baseActionURL}?action=bouger&amp;id={./@id}&amp;ordre={./@order}&amp;parent={../@id}&amp;sens=descendre#[{./@id}]">
						<xsl:call-template 
							name="icon.pbas" 
							/>
					</a>
				</xsl:if>
				<xsl:if 
					test="position()=last()">
					 &#160; </xsl:if>
			</td>
		</tr>
	</table>
</xsl:template>
						
<!-- option folder-->
<xsl:template name="options.book">
	<xsl:variable name='lar'>
	<xsl:choose>
		<xsl:when test="/xml/useicon[@val='vrai']">
			21
		</xsl:when>
		<xsl:otherwise>70
		</xsl:otherwise>
	</xsl:choose>
	</xsl:variable>
	<table border="0">
		<tr>
			<td class="uportal-label" nowrap="true" width="{$lar}">
				<a href="{$baseActionURL}?action=couper&amp;id_folder_courant={../@id}&amp;id_book={./@id}&amp;id_element_copy={./@id}#[{./@id}]">
					<xsl:call-template name="icon.pcut" />
				</a>
			</td>	
			<td class="uportal-label" nowrap="true" width="{$lar}">
				<a href="{$baseActionURL}?action=ModifyBookMark&amp;id_folder_courant={../@id}&amp;id_book={./@id}#[{./@id}]">
					<xsl:call-template name="icon.pmod" />
				</a>
			</td>
			<td class="uportal-label" nowrap="true" width="{$lar}">
				<a href="{$baseActionURL}?action=DeleteBookMark&amp;id_folder_courant={../@id}&amp;id_book={./@id}#[{./@id}]">
					<xsl:call-template name="icon.psup" />
				</a>
			</td>
			<td class="uportal-label" nowrap="true" width="{$lar}">
				<xsl:if test="./@order!=1">
					<a href="{$baseActionURL}?action=bouger&amp;id_folder_courant={../@id}&amp;id={./@id}&amp;ordre={./@order}&amp;parent={../@id}&amp;sens=monter#[{./@id}]">
						<xsl:call-template name="icon.phaut" />
					</a>
				</xsl:if>
				<xsl:if test="./@order=1">
						&#160;
				</xsl:if>
			</td>
			<td class="uportal-label" nowrap="true" width="{$lar}">
				<xsl:if test="position()!=last()">
					<a href="{$baseActionURL}?action=bouger&amp;id_folder_courant={../@id}&amp;id={./@id}&amp;ordre={./@order}&amp;parent={../@id}&amp;sens=descendre#[{./@id}]">
						<xsl:call-template name="icon.pbas" />
					</a>
				</xsl:if>
				<xsl:if test="position()=last()">
					&#160;
				</xsl:if>
			</td>
		</tr>
	</table>

</xsl:template>
								
<!-- Affichage du chemin-->
<xsl:template match="path">		
	<xsl:for-each select="./element_pile">
		<a href="{$baseActionURL}?action=defaultview&amp;id_folder_courant={./@id}&amp;id_book_courant=0#[{./@id}]">
			<xsl:value-of select="./@title" />
		</a>
		<xsl:if test="position()!=last()">
		&gt;	
		</xsl:if>
	</xsl:for-each>
	<xsl:apply-templates select="/xml/id_book_courant"/>
</xsl:template>
<!--Affichage du bookmark courant s'il est selectione-->
<xsl:template match="id_book_courant">
	&gt;
	<a href="{$baseActionURL}?action=defaultview&amp;id={./@id}&amp;id_folder_courant={../@id}&amp;id_book_courant={./@id}&amp;title_book_courant={./@title}#[{./@id}]">
		<xsl:value-of select="./@title"/>
	</a>
</xsl:template>
<!--Affichage de l'element en copie-->
<xsl:template match="id_elements_copy">
	<tr class="uportal-background-highlight">
		<td><table border="0"><tr><td class="uportal-text" colspan="5">
			Element(s) en copie : 
		</td></tr>	
		<xsl:apply-templates select="./id_element_copy"/>
		</table></td>
		
	</tr>
</xsl:template>
<xsl:template match="id_element_copy">
	<tr>
		<td width="20">
			<xsl:if test="./@type='book'">
				<xsl:call-template name="icon.book" />
			</xsl:if>
			<xsl:if test="./@type='folder'">
				<xsl:call-template name="icon.fold" />
			</xsl:if>
		</td>
		<td class="uportal-text">
			<xsl:value-of select="./@title" /> 
		</td>
		<td width="300" align="right">&#160;</td>
		<td width="20"><a class="navigation" href="{$baseActionURL}?action=collerUn&amp;id_element_copy={./@id}">
						<xsl:call-template name="icon.coller" />
					</a></td>
		<td>
			<a href="{$baseActionURL}?action=supcoller&amp;id_element_copy={./@id}">
				<xsl:call-template name="icon.supcopie" />
			</a>
		</td>
		
	</tr>
</xsl:template>

<xsl:template match="ligne">
 <br></br><xsl:value-of select="." />
</xsl:template>

</xsl:stylesheet>