<?xml version="1.0" encoding="iso-8859-1"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <!-- Import the bookmark tree stylesheet -->
	<xsl:import href="bookmark_tree_html.xsl" />

  <!-- Make sure that XHTML is being output to facilitate caching -->
  <xsl:output method="xml" indent="yes"/>

  <!-- Take the baseActionURL and the location of the images as parameters -->
	<xsl:param name="baseActionURL">default</xsl:param>
	<xsl:param name="imagesURL">media/org/esupportail/portal/channels/CSignet/</xsl:param>

  <!-- Find out whether you are editing a folder or a bookmark -->
	<xsl:param name="EditMode">EditBookmark</xsl:param>
  <xsl:variable name="EditTitle">
    <xsl:text>diter </xsl:text>
		<xsl:choose>
			<xsl:when test="$EditMode='EditBookmark'">
				un signet
			</xsl:when>
			<xsl:when test="$EditMode='EditFolder'">
				un rpertoire
			</xsl:when>
		</xsl:choose>
  </xsl:variable>

  <xsl:variable name="EditForm">
    <xsl:text>diter </xsl:text>
		<xsl:choose>
			<xsl:when test="$EditMode='EditBookmark'">le signet</xsl:when>
			<xsl:when test="$EditMode='EditFolder'">le rpertoire</xsl:when>
		</xsl:choose>
  </xsl:variable>

	<xsl:template match="/">
    <form action="{$baseActionURL}?command={$EditMode}" method="post">
    <table border="0" cellpadding="6">
            <tr>
              <td class="uportal-channel-subtitle"><xsl:value-of select="$EditTitle"/></td>
            </tr></table>
		<xsl:call-template name="BookmarkTree">
      <xsl:with-param name="TreeMode"><xsl:value-of select="$EditMode"/></xsl:with-param>
    </xsl:call-template>
      <hr/>Slectionnez le
      <xsl:choose>
        <xsl:when test="$EditMode='EditBookmark'">
          signet
        </xsl:when>
        <xsl:when test="$EditMode='EditFolder'">
          rpertoire
        </xsl:when>
      </xsl:choose>
      que vous souhaitez diter.<hr/>
      <input type="submit" name="edit" value="{$EditForm}" class="uportal-button"/>
      <input type="submit" name="cancel" value="Annuler" class="uportal-button"/>
    </form>
	</xsl:template>

</xsl:stylesheet>
