<?xml version="1.0" encoding="iso-8859-1"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <!-- Make sure that XHTML is being output to facilitate caching -->
  <xsl:output method="xml" indent="yes"/>

  <!-- Take the baseActionURL and the location of the images as parameters -->
	<xsl:param name="baseActionURL">default</xsl:param>
	<xsl:param name="imagesURL">media/org/esupportail/portal/channels/CSignet/</xsl:param>

  <!-- Find out whether you are editing a folder or a bookmark -->
	<xsl:param name="EditMode">EditBookmark</xsl:param>
  <xsl:variable name="EditTitle">
    <xsl:text>Edit </xsl:text>
    <xsl:value-of select="substring-after($EditMode,'Edit')"/>
  </xsl:variable>

  <!-- Get current values -->
  <xsl:param name="FolderName"></xsl:param>
  <xsl:param name="FolderTitle"></xsl:param>
  <xsl:param name="FolderID">invalid Folder ID</xsl:param>
  <xsl:param name="BookmarkTitle"></xsl:param>
  <xsl:param name="BookmarkURL">http://</xsl:param>
  <xsl:param name="BookmarkDescription"></xsl:param>
  <xsl:param name="BookmarkID">invalid Bookmark ID</xsl:param>

	<xsl:template match="/">
		<form action="{$baseActionURL}?command={$EditMode}" method="post">
			<table border="0" cellpadding="6">
				<tr>
					<td class="uportal-channel-subtitle">diter
						<xsl:choose>
							<xsl:when test="$EditMode='EditBookmark'">
								 un signet
							</xsl:when>
							<xsl:when test="$EditMode='EditFolder'">
								 un rpertoire
							</xsl:when>
						</xsl:choose>
					</td>
				</tr>
			</table>


      <xsl:choose>
        <xsl:when test="$EditMode='EditFolder'">
          <table border="0">

            <tr><td class="uportal-label">Nom du rpertoire :</td></tr>
            <tr><td><input type="text" name="FolderTitle" class="uportal-input-text" value="{$FolderTitle}"></input></td></tr>
            <tr><td>
              <input type="hidden" name="FolderID" value="{$FolderID}"></input>
              <input type="submit" name="update" value="Mettre  jour" class="uportal-button"></input>
              <input type="submit" name="cancel" value="Annuler" class="uportal-button"></input>
              </td>
            </tr>
          </table>
        </xsl:when>
        <xsl:when test="$EditMode='EditBookmark'">
          <table border="0">
            <tr>
              <td class="uportal-label">Titre du signet :</td>
            </tr>
            <tr>
              <td><input type="text" name="BookmarkTitle" class="uportal-input-text" value="{$BookmarkTitle}" size="20"></input></td>
            </tr>
            <tr>
              <td class="uportal-label">URL :</td>
            </tr>
            <tr>
              <td><input type="text" name="BookmarkURL" class="uportal-input-text" value="{$BookmarkURL}" size="20"></input></td>
            </tr>
            <tr>
              <td class="uportal-label">Description :</td></tr>
            <tr>
              <td><textarea rows="5" cols="20" name="BookmarkDescription" class="uportal-input-text"><xsl:value-of select="$BookmarkDescription"/></textarea></td>
            </tr>
            <tr>
              <td>
              <input type="hidden" name="BookmarkID" value="{$BookmarkID}"></input>
              <input type="submit" name="update" value="Mettre  jour" class="uportal-button"></input>
              <input type="submit" name="cancel" value="Annuler" class="uportal-button"></input>
              </td>
            </tr>
          </table>
        </xsl:when>
      </xsl:choose>

    </form>
	</xsl:template>

</xsl:stylesheet>
