<?xml version="1.0"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <!-- Import the bookmark tree stylesheet -->
	<xsl:import href="bookmark_tree_html.xsl" />

  <!-- Make sure that XHTML is being output to facilitate caching -->
  <xsl:output method="xml" indent="yes"/>

  <!-- Take the baseActionURL and the location of the images as parameters -->
	<xsl:param name="baseActionURL">default</xsl:param>
	<xsl:param name="imagesURL">media/org/jasig/portal/channels/bookmarks/</xsl:param>

  <!-- Find out whether you are editing a folder or a bookmark -->
	<xsl:param name="EditMode">EditBookmark</xsl:param>
  <xsl:variable name="EditTitle">
    <xsl:text>Edit </xsl:text>
    <xsl:value-of select="substring-after($EditMode,'Edit')"/>
  </xsl:variable>

	<xsl:template match="/">
    <form action="{$baseActionURL}?command={$EditMode}" method="post">
    <table border="0" cellpadding="6">
            <tr>
              <td class="uportal-channel-subtitle"><xsl:value-of select="$EditTitle"/></td>
            </tr></table>
		<xsl:call-template name="BookmarkTree">
      <xsl:with-param name="TreeMode"><xsl:value-of select="$EditMode"/></xsl:with-param>
    </xsl:call-template>
      <hr/>Please select the
      <xsl:choose>
        <xsl:when test="$EditMode='EditBookmark'">
          bookmark
        </xsl:when>
        <xsl:when test="$EditMode='EditFolder'">
          folder
        </xsl:when>
      </xsl:choose>
      you wish to edit.<hr/>
      <input type="submit" name="SubmitButton" value="{$EditTitle}" class="uportal-button"/>
      <input type="submit" name="SubmitButton" value="Cancel" class="uportal-button"/>
    </form>
	</xsl:template>

</xsl:stylesheet>
