<?xml version='1.0' encoding='utf-8' ?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

	<xsl:import href="bookmark_tree_html.xsl" /> 
	
	<xsl:output method="xml" indent="no"/>
	
	<xsl:param name="baseActionURL">default</xsl:param>
	<xsl:param name="mediaPath">media/org/jasig/portal/channels/bookmarks</xsl:param>
	
	<xsl:template match="/">
		
			<xsl:call-template name="BookmarkTree"/>
<table width="100%" cellpadding="2" cellspacing="0">
<tr><td><img src="{$mediaPath}/transparent.gif" height="8" width="8"/></td></tr>
			<tr class="uportal-background-light"><td align="left"><a href="{$baseActionURL}?command=AddBookmark"><img src="{$mediaPath}/bookmark_add.gif" alt="add a bookmark" border="0" title="Add a bookmark"/></a>
			<a href="{$baseActionURL}?command=DeleteBookmark"><img src="{$mediaPath}/bookmark_delete.gif" border="0" alt="delete a bookmark" title="Delete a bookmark"/></a>
      <!-- 3-FEB-2003: "Edit" button added by Mark Mazelin, Cedarville University -->
      <a href="{$baseActionURL}?command=EditBookmark"><img src="{$mediaPath}/bookmark_edit.gif" border="0" alt="Edit a bookmark" title="Edit a bookmark"/></a>
      <a href="{$baseActionURL}?command=AddFolder"><img src="{$mediaPath}/folder_add.gif" border="0" alt="add a folder" title="Add a folder"/></a>
      <a href="{$baseActionURL}?command=DeleteFolder"><img src="{$mediaPath}/folder_delete.gif" border="0" alt="Delete a folder" title="Delete a folder"/></a>
      <!-- 5-FEB-2003: "Edit" button added by Mark Mazelin, Cedarville University -->
      <a href="{$baseActionURL}?command=EditFolder"><img src="{$mediaPath}/folder_edit.gif" border="0" alt="Edit a folder" title="Edit a folder"/></a>
      <!-- 30-DEC-2002: "Save" button added by Mark Mazelin, Cedarville University -->
      <a href="{$baseActionURL}?command=Save"><img src="{$mediaPath}/save_state.gif" border="0" alt="Save bookmark folder state" title="Save bookmark folder open/closed state"/></a>
      <a href="{$baseActionURL}?command=MoveBookmark"><img src="{$mediaPath}/addToFolder.gif" border="0" alt="Move bookmark " title="Move bookmark "/></a>
      <a href="{$baseActionURL}?command=MoveFolder"><img src="{$mediaPath}/moveFolder.gif" border="0" alt="Move folder " title="Move folder "/></a>
      </td></tr>
      </table>

		
	</xsl:template>

</xsl:stylesheet>
<!-- Stylus Studio meta-information - (c)1998-2001 eXcelon Corp.
<metaInformation>
<scenarios/>
</metaInformation>
-->
