<?xml version="1.0" encoding="ISO-8859-1" ?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
   <xsl:output method="html" encoding="ISO-8859-1" />

   <xsl:template match="/">
      <html>
         <title>Liste des tches</title>

         <body>
            <xsl:for-each select="taches">
            <h1>Liste des tches du groupe <xsl:value-of select="@groupe" /></h1>
            
            <table border="1">
            <tr align="center"><td><b>Tche</b></td>
            	<td><b>Avancement (%)</b></td>
            	<td><b>Priorit</b></td>
            	<td><b>Responsable</b></td>
            	<td><b>CVS</b></td>
            	<td><b>Documentation</b></td>
            	<td><b>Dbut</b></td>
            	<td><b>Fin des spcifs</b></td>
            	<td><b>Fin prvue</b></td></tr>

            <xsl:for-each select="tache">
                <tr align="center"><td>
                  <xsl:value-of select="nom" />
                  </td>

                  <td> 
                  <xsl:value-of select="@avancement" />
                  </td>

                  <td> 
                  <xsl:value-of select="@priorite" />
                  </td>

                  <td> 
                  <xsl:value-of select="responsable" />
                  </td>

                  <td>
                  <xsl:if test = "@dispoCVS='O'">
                  Oui (Module : <xsl:value-of select="moduleCVS" />)
                  </xsl:if>
                  <xsl:if test = "@dispoCVS!='O'">
                  Non
                  </xsl:if>
                  </td>

                  <td> 
                  <xsl:if test = "@dispoDoc='O'">
                  <xsl:element  name = "a"><xsl:attribute  name = "href" ><xsl:value-of select="URL" /></xsl:attribute>Oui</xsl:element>
                  </xsl:if>
                  <xsl:if test = "@dispoDoc!='O'">
                  Non
                  </xsl:if>
                  </td>

                  <td>
		  <xsl:if test = "dateDemarrage=''">???</xsl:if>
                  <xsl:value-of select="dateDemarrage" />
                  </td>

                  <td> 
		  <xsl:if test = "dateFinSpecif=''">???</xsl:if>
                  <xsl:value-of select="dateFinSpecif" />
                  </td>

                  <td> 
		  <xsl:if test = "dateDisponibilite=''">???</xsl:if>
                  <xsl:value-of select="dateDisponibilite" />
                  </td>

               </tr>
            </xsl:for-each>
            </table>

            <h1>Descriptif des tches</h1>
            <table>
            <xsl:for-each select="tache">
            <tr><td valign="top"><b><xsl:value-of select="nom" /></b> : </td>
            <td><xsl:value-of select="description" /></td></tr>
			</xsl:for-each>
			</table>
			</xsl:for-each>
         </body>
      </html>
   </xsl:template>
</xsl:stylesheet>

