package org.esupportail.portal.channels.CDigester.beans;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Vector;

/**
 * @author mlarchet
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class Folder implements Comparable {
	
	private String name = null;
	private Vector subfolders = null;
	private Vector files = null;
	
	/**
	 * Constructeur
	 */
	public Folder() {
		subfolders = new Vector();
		files = new Vector();
	}
	
	public String getName() {
		return name;
	}
	
	public void setName(String name) {
		this.name = name;
	}
	
	public void addFolder(Folder fol) {
		subfolders.add(fol);
	}
	
	public void addFile(File file) {
		files.add(file);
	}
	
	public Collection getSubFolders() {
		return subfolders;
	}
	
	public Collection getFiles() {
		return files;
	}
	
	public String toXMLString() {
		StringBuffer xml = new StringBuffer();
		xml.append("<folder name=\"" + getName() + "\">\n");
		
		// Tri des sous rpertoires
		Collections.sort(subfolders);
		Iterator i = subfolders.iterator();
		while(i.hasNext()) {
			Folder tmp = (Folder)i.next();
			xml.append(tmp.toXMLString());
		}
		
		// Tri des fichiers
		Collections.sort(files);
		i = files.iterator();
		while(i.hasNext()) {
			File tmp = (File)i.next();
			xml.append(tmp.toXMLString());
		}
		
		xml.append("</folder>\n");
		return xml.toString();
	}

	/**
	 * Implmentation interface Comparable
	 */
	public int compareTo(Object o) {
		if(!(o instanceof Folder)) {
            throw new ClassCastException("Cannot compare objects from different classes");
        }
        Folder fol = (Folder)o;
        return getName().compareTo(fol.getName());
	}
}
