package org.esupportail.portal.channels.CDigester.config;

import java.io.IOException;
import java.net.URL;

import org.apache.commons.digester.Digester;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.esupportail.portal.channels.CDigester.beans.File;
import org.esupportail.portal.channels.CDigester.beans.Folder;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/**
 * @author mlarchet
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class Config {
	
	protected static Log log = LogFactory.getLog(Config.class);	
	private static String confFile = "/properties/channels/org_esup/CDigester/CDigester.xml";
	private static Config singleton = null;
	
	private Digester dig = null;
	private URL ressourceURL = null;
	private Folder racine = null;
	
	/**
	 * Rcupre l'instance du singleton Config
	 * @return l'objet Config
	 */
	public static synchronized Config getInstance() {
		if(singleton == null) {
			singleton = new Config();
			singleton.parseConfig();
		}
		return singleton;
	}
	
	/**
	 * Constructeur
	 */
	private Config() {
		if(log.isDebugEnabled()) {
			log.debug("Config::Config()");
		}
	}
	
	/**
	 * Lis la configuration
	 */
	private void parseConfig() {
		if(log.isDebugEnabled()) {
			log.debug("Config::parseConfig()");
		}
		
		// Configuration Digester
		dig = new Digester();
		dig.push(this);
		
		dig.addObjectCreate("*/folder", Folder.class);
		dig.addSetProperties("*/folder");
		dig.addSetNext("*/folder", "addFolder");
		
		dig.addObjectCreate("*/file", File.class);
		dig.addSetProperties("*/file");
		dig.addSetNext("*/file", "addFile");
		
		// Parsing
		ressourceURL = Config.class.getResource(confFile);
		if(ressourceURL != null) {
			try {
				dig.parse(new InputSource(ressourceURL.toExternalForm()));
			}
			catch(IOException e) {
				log.error("Config::parseConfig() : IOException :\n" + e);
			}
			catch(SAXException e) {
				log.error("Config::parseConfig() : SAXException :\n" + e);
			}
			catch(Exception e) {
				log.error("Config::parseConfig() : Exception :\n" + e);
			}
		}
	}
	
	public void addFolder(Folder fol) {
		racine = fol;
	}
	
	public Folder getRacine() {
		if(racine == null) {
			Folder tmp = new Folder();
			tmp.setName("toto");
			return tmp;
		}
		return racine;
	}
}
