package org.esupportail.portal.channels.CGetTicket;

import org.esupportail.portal.utils.CAS;
import org.esupportail.portal.utils.CASExceptions.CASGenericException;
import org.esupportail.portal.utils.CASExceptions.CASPermException;
import org.esupportail.portal.utils.CASExceptions.CASTempException;
import org.jasig.portal.PortalException;
import org.jasig.portal.channels.BaseChannel;
import org.jasig.portal.utils.XSLT;
import org.xml.sax.ContentHandler;

/** 
*  A simple example channel for the uPortal.
*  @author Owen Gunden (nog7g@virginia.edu)
*/
public class CGetTicket extends BaseChannel {
	
	/** 
	 *  Constructeur. 
	 */ 
	public CGetTicket() { 
	}
	
	/** 
	 * Output channel content to the portal
	 * @param out a sax document handler
	 */
	public void renderXML(ContentHandler out) throws PortalException {	
		StringBuffer xml = new StringBuffer();
		int CodeException;
		String MsgException;
		
		String ticket = "";
		String Service = "imap://univ.fr";
		
		xml.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>"); 
	    
		try{
			ticket = CAS.get_pt(staticData, Service);
			xml.append("<ticket>" + ticket + "</ticket>");			
		}
		catch(CASTempException exp){
			CodeException = exp.getExceptionCode();
			MsgException = exp.getMessage();
			   
			xml.append("<error code=\"" + CodeException + "\" msg=\"" + MsgException + "\" type=\"Temporaire\"/>");	
		}
		catch(CASPermException exp){
			CodeException = exp.getExceptionCode();
			MsgException = exp.getMessage();
			   
			xml.append("<error code=\"" + CodeException + "\" msg=\"" + MsgException + "\" type=\"Permanente\"/>");			   
		}
		catch(CASGenericException exp){
			CodeException = exp.getExceptionCode();
			MsgException = exp.getMessage();
			   
			xml.append("<error code=\"" + CodeException+"\" msg=\"" + MsgException+"\" type=\"Generic (autre)\"/>");
		}
		
		
	    // Create a new XSLT styling engine
	    XSLT xslt = new XSLT(this);
	 
	    // pass the result XML to the styling engine.
	    xslt.setXML(xml.toString());
	 
	    // specify the stylesheet selector
	    xslt.setXSL("CGetTicket.ssl","normal", runtimeData.getBrowserInfo());

	    // set the output Handler for the output.
	    xslt.setTarget(out);
	 
	    // do the deed
	    xslt.transform();
	}
}
