/*
 * Decompiled with CFR 0.152.
 */
package edu.yale.its.tp.cas.proxy;

import com.mockrunner.mock.web.MockHttpServletRequest;
import com.mockrunner.mock.web.MockHttpServletResponse;
import com.mockrunner.mock.web.MockServletConfig;
import com.mockrunner.mock.web.MockServletContext;
import edu.yale.its.tp.cas.proxy.ProxyTicketReceptor;
import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import junit.framework.TestCase;

public class ProxyTicketReceptorTest
extends TestCase {
    private static final String CASPROXYURL_INIT_PARAM_NAME = "edu.yale.its.tp.cas.proxyUrl";
    private MockServletConfig basicConfig;
    private MockServletContext basicContext;
    private MockHttpServletRequest mockRequest;
    private MockHttpServletResponse mockResponse;
    private ProxyTicketReceptor proxyTicketReceptor;

    protected void setUp() throws Exception {
        super.setUp();
        this.basicConfig = new MockServletConfig();
        this.basicConfig.setInitParameter(CASPROXYURL_INIT_PARAM_NAME, "https://someplace.edu/cas/proxy");
        this.mockRequest = new MockHttpServletRequest();
        this.mockResponse = new MockHttpServletResponse();
        this.basicContext = new MockServletContext();
        this.basicConfig.setServletContext((ServletContext)this.basicContext);
        this.proxyTicketReceptor = new ProxyTicketReceptor();
    }

    public void testNoCasProxyUrlInit() {
        this.basicConfig.setInitParameter(CASPROXYURL_INIT_PARAM_NAME, null);
        try {
            this.proxyTicketReceptor.init((ServletConfig)this.basicConfig);
        }
        catch (ServletException e) {
            return;
        }
        ProxyTicketReceptorTest.fail((String)"Initialization should have thrown ServletException because casProxyUrl was not set.");
    }

    public void testBasicInit() throws ServletException {
        this.proxyTicketReceptor.init((ServletConfig)this.basicConfig);
    }

    public void testContextProxyUrlInit() throws ServletException {
        this.basicConfig.setInitParameter(CASPROXYURL_INIT_PARAM_NAME, null);
        this.basicContext.setInitParameter(CASPROXYURL_INIT_PARAM_NAME, "https://someplace.com/cas/proxy");
        this.proxyTicketReceptor.init((ServletConfig)this.basicConfig);
    }

    public void testInsecureProxyUrlInit() {
        this.basicConfig.setInitParameter(CASPROXYURL_INIT_PARAM_NAME, "http://www.insecure.com/cas/proxy");
        try {
            this.proxyTicketReceptor.init((ServletConfig)this.basicConfig);
        }
        catch (ServletException e) {
            return;
        }
        ProxyTicketReceptorTest.fail((String)"Initialization should have thrown ServletException because casProxyUrl was not an https: URL.");
    }

    public void testContextInsecureProxyUrlInit() {
        this.basicConfig.setInitParameter(CASPROXYURL_INIT_PARAM_NAME, null);
        this.basicContext.setInitParameter(CASPROXYURL_INIT_PARAM_NAME, "http://www.insecure.com/cas/proxy");
        try {
            this.proxyTicketReceptor.init((ServletConfig)this.basicConfig);
        }
        catch (ServletException e) {
            return;
        }
        ProxyTicketReceptorTest.fail((String)("Initialization should have thrown ServletException because casProxyUrl was not an https: URL.:" + (Object)((Object)this.proxyTicketReceptor)));
    }

    public void testReceiveProxyTicket() throws ServletException, IOException {
        this.proxyTicketReceptor.init((ServletConfig)this.basicConfig);
        this.mockRequest.setRequestURL("https://someplace.com/app/casProxyReceptor?pgtIou=FOO&pgtId=BAR");
        this.proxyTicketReceptor.doGet((HttpServletRequest)this.mockRequest, (HttpServletResponse)this.mockResponse);
    }

    public void testGetUnknownProxyTicket() throws ServletException, IOException {
        this.proxyTicketReceptor.init((ServletConfig)this.basicConfig);
        ProxyTicketReceptorTest.assertNull((Object)ProxyTicketReceptor.getProxyTicket("SPLAT", "http://www.nowhere.com/someService"));
    }
}

