package edu.yale.its.tp.portal.security;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.security.*;
import org.jasig.portal.security.provider.ChainingSecurityContext;

/**
 * <p>
 * A SecurityContext that can never be authenticated.
 * </p>
 * An unauthenticatable security context which a security context factory
 * may return in the case where its initialization of the security context it was supposed 
 * to return failed.
 * 
 * @author andrew.petro@yale.edu 
 * @version $Revision: 1.7 $ $Date: 2004/07/14 17:09:27 $
 */
public class BrokenSecurityContext extends ChainingSecurityContext {

    public static final int BROKEN_AUTH_TYPE = 666;
    
    private static final Log log = LogFactory.getLog(BrokenSecurityContext.class);


    /**
     * Instantiate a BrokenSecurityContext
     */
    public BrokenSecurityContext() {
        super();
    }
    
    public int getAuthType() {
        return BROKEN_AUTH_TYPE;
    }

    public void authenticate() throws PortalSecurityException {
        if (log.isTraceEnabled()) {
            log.trace("entering authenticate()");
        }
        // Note that this.isauth is still false.
        super.authenticate();
        if (log.isTraceEnabled()) {
            log.trace("returning from authenticate()");
        }
        return;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getName());
        return sb.toString();
    }
}