/*
 * Created on 3 dc. 2004
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.esupportail.portal.channels.CAgenda.actions;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import org.esupportail.portal.channels.CAgenda.beans.Person;
import org.esupportail.portal.channels.CAgenda.data.BDDConnection;
import org.esupportail.portal.utils.channels.FrameWorkException;
import org.esupportail.portal.utils.channels.MainChannel;
import org.esupportail.portal.utils.channels.SubChannel;
import org.esupportail.portal.utils.channels.plugins.Message;
import org.esupportail.portal.utils.channels.plugins.MessageBean;
import org.jasig.portal.ChannelRuntimeData;
import org.jasig.portal.IMimeResponse;
import org.jasig.portal.PortalException;

/**
 * @author mlarchet
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class ViewPersons extends SubChannel implements IMimeResponse {

	private Collection persons = null;
	
	/**
	 * @param mainChannel
	 */
	public ViewPersons(MainChannel mainChannel) {
		super(mainChannel);
	}

	public Boolean init(ChannelRuntimeData rd) throws PortalException, FrameWorkException {
		runtimeData = rd;
		
		// Rcupration des enregistrements
		try {
			persons = BDDConnection.getAllPersons();
		}
		catch(SQLException e) {
			Message.message(mainChannel, runtimeData, new MessageBean(e.getMessage()), "default");
			return Boolean.FALSE;
		}
		return Boolean.TRUE;
	}
	
	public Boolean setXML() throws FrameWorkException {
		// Tri des personnes
		Collections.sort((List)persons);
		// Gnration du xml
		StringBuffer xml = new StringBuffer();
		Iterator i = persons.iterator();
		while(i.hasNext()) {
			Person tmp = (Person)i.next();
			xml.append(tmp.toXMLString());
		}
		this.xml = xml.toString();
		// Ajout du paramtre pour le download
		addDownloadXslParameter();
		return Boolean.TRUE;
	}
	
	public Boolean downloadinit(ChannelRuntimeData rd) throws PortalException, FrameWorkException {
		runtimeData = rd;
		return Boolean.FALSE;
	}

	public String getContentType() {
		return "text/plain";
	}

	public InputStream getInputStream() throws IOException {
		return null;
	}

	public void downloadData(OutputStream out) throws IOException {
		PrintWriter writer = new PrintWriter(out);
	    Iterator i = persons.iterator();
	    while(i.hasNext()) {
	    	Person tmp = (Person)i.next();
	        writer.println(tmp.getName() + ";" + tmp.getFirstname() + ";" + tmp.getPhone() + ";" + tmp.getMail());
	    }
	    writer.close();
	}

	public String getName() {
		// TODO Auto-generated method stub
		return null;
	}

	public Map getHeaders() {
		 HashMap map = new HashMap();
	     map.put("Content-disposition", "attachment; filename=" + "agenda.csv");
	     return map;
	}

	public void reportDownloadError(Exception e) {
	}
}
