package org.esupportail.portal.channels.CHelloWorld;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.ChannelRuntimeData;
import org.jasig.portal.ChannelRuntimeProperties;
import org.jasig.portal.ChannelStaticData;
import org.jasig.portal.IChannel;
import org.jasig.portal.PortalEvent;
import org.jasig.portal.PortalException;
import org.jasig.portal.utils.XSLT;
import org.xml.sax.ContentHandler;

/** 
 *  A simple example channel for the uPortal.
 *  @author Owen Gunden (nog7g@virginia.edu)
 */
public class CHelloWorld implements IChannel {

	protected static Log log = LogFactory.getLog(CHelloWorld.class);

	private static final int NORMAL_MODE = 42;
	private static final int ABOUT_MODE  = 31337;
	private int mode = 0;

	private ChannelStaticData staticData = null;
	private ChannelRuntimeData runtimeData = null;
	
	private String name = null;
	private String name_prev = null;
  
	/** 
	 * Constructeur. 
	 */ 
	public CHelloWorld() {
		this.name = "World";
		this.name_prev = "";
		this.mode = NORMAL_MODE;
	}

	/** 
	 *  Returns channel runtime properties.
	 *  Satisfies implementation of Channel Interface.
	 *
	 *  @return handle to runtime properties 
	 */ 
	public ChannelRuntimeProperties getRuntimeProperties() {
		if(log.isDebugEnabled()) {
			log.debug("CHelloWorld::getRuntimeProperties()");
		}
		return new ChannelRuntimeProperties();
	}
  
	/** 
	 *  Process layout-level events coming from the portal.
	 *  Satisfies implementation of IChannel Interface.
	 *
	 *  @param <b>PortalEvent</b> ev a portal layout event
	 */
	public void receiveEvent(PortalEvent ev) {
		if(log.isDebugEnabled()) {
			log.debug("CHelloWorld::receiveEvent()");
		}
		if (ev.getEventNumber() == PortalEvent.ABOUT_BUTTON_EVENT) {
			log.info("CHelloWorld::receiveEvent() : Ev\u00EAnement ABOUT d\u00E9clench\u00E9");
			mode = ABOUT_MODE;
		}
	}
  
	/** 
	 *  Receive static channel data from the portal.
	 *  Satisfies implementation of IChannel Interface.
	 *
	 *  @param <b>ChannelStaticData</b> sd static channel data
	 */
	public void setStaticData(ChannelStaticData sd) {
		if(log.isDebugEnabled()) {
			log.debug("CHelloWorld::setStaticData()");
		}
		this.staticData = sd;
	}
  
	/** 
	 *  Receive channel runtime data from the portal.
	 *  Satisfies implementation of IChannel Interface.
	 *
	 *  @param <b>ChannelRuntimeData</b> rd handle to channel runtime data
	 */
	public void setRuntimeData(ChannelRuntimeData rd) {
		if(log.isDebugEnabled()) {
			log.debug("CHelloWorld::setRuntimeData()");
		}
		this.runtimeData = rd;
    
		if (runtimeData.getParameter("submit") != null) {
			log.info("CHelloWorld::setRuntimeData() : bouton submit");
			name = runtimeData.getParameter("name");
			name_prev = name;
		} 

		if (runtimeData.getParameter("clear") != null) {
			log.info("CHelloWorld::setRuntimeData() : bouton clear");
			name_prev = "";
		}

		if (runtimeData.getParameter("back") != null) {
			log.info("CHelloWorld::setRuntimeData() : bouton back");
			mode = NORMAL_MODE;
		}
	}
  
	/** Output channel content to the portal
	 *  @param out a sax document handler
	 */
	public void renderXML(ContentHandler out) throws PortalException {
		if(log.isDebugEnabled()) {
			log.debug("CHelloWorld::renderXML()");
		}
		StringBuffer xml = new StringBuffer();
  	
		xml.append("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>"); 
		String stylesheet = "normal"; 
		if (mode == NORMAL_MODE) {
			log.info("CHelloWorld::renderXML() : rendu mode normal");
			xml.append("<name>"+name+"</name>");
			stylesheet = "normal";
		} else if (mode == ABOUT_MODE) {
			log.info("CHelloWorld::renderXML() : rendu mode about");
			xml.append("<about channel=\"Hello World\">Ce canal a \u00E9t\u00E9 cr\u00E9\u00E9 et adapt\u00E9 ");
			xml.append("\u00E0 des fins de d\u00E9monstration par Mathieu Larchet &lt;mathieu.larchet@");
			xml.append("univ-nancy2.fr&gt;</about>");
    	
			stylesheet = "about";
		}

		// Instanciation d'un moteur XSLT
		XSLT xslt = new XSLT(this);
    
		// Le XML est transmis au moteur
		xslt.setXML(xml.toString());
    
		// Dfinition de la feuille de style de slection
		xslt.setXSL("CHelloWorld.ssl", stylesheet, runtimeData.getBrowserInfo());
    
		// Transmissions des paramtres au XSL
		xslt.setStylesheetParameter("baseActionURL",runtimeData.getBaseActionURL());
		xslt.setStylesheetParameter("name_prev", name_prev);

		// Dfinition du flux de sortie
		xslt.setTarget(out);
    
		// Lancemement de la transformation
		xslt.transform();
	}
}
