package org.esupportail.portal.channels.CAgenda.actions;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

import org.esupportail.portal.channels.CAgenda.beans.Person;
import org.esupportail.portal.channels.CAgenda.config.ParseXML;
import org.esupportail.portal.channels.CAgenda.data.BDDConnection;
import org.esupportail.portal.channels.CAgenda.utils.UploadWorker;
import org.esupportail.portal.utils.channels.FrameWorkException;
import org.esupportail.portal.utils.channels.MainChannel;
import org.esupportail.portal.utils.channels.SubChannel;
import org.esupportail.portal.utils.channels.plugins.Message;
import org.esupportail.portal.utils.channels.plugins.MessageBean;
import org.jasig.portal.ChannelRuntimeData;
import org.jasig.portal.PortalException;

/**
 * @author mlarchet
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class Upload extends SubChannel {

	Collection persons = null;
	
	/**
	 * @param mainChannel
	 */
	public Upload(MainChannel mainChannel) {
		super(mainChannel);
	}

	public Boolean init(ChannelRuntimeData rd) throws PortalException, FrameWorkException {
		runtimeData = rd;
		return Boolean.TRUE;
	}
	
	public Boolean setXML() throws FrameWorkException {
		this.xml = "";
		return Boolean.TRUE;
	}
	
	public Boolean parseinit(ChannelRuntimeData rd) throws PortalException, FrameWorkException {
		runtimeData = rd;
		
		// Rcupration du fichier upload
		UploadWorker worker = new UploadWorker(runtimeData);
		
		try {
			worker.parseFile("fichier");
		}
		catch(FileNotFoundException e) {
			Message.message(mainChannel, runtimeData, new MessageBean("Aucun fichier upload\u00E9"), "viewpersons");
			return Boolean.FALSE;
		}
		
		// Parsing du fichier XML
		ParseXML parser = new ParseXML();
		try {
			parser.setInputStream(worker.getInputStream());
		}
		catch(IOException e) {
			Message.message(mainChannel, runtimeData, new MessageBean("Erreur lors de la r\u00E9cup\u00E9ration du fichier"), "viewpersons");
			return Boolean.FALSE;
		}
		
		parser.parse();
		persons = parser.getPersons();
		
		// Vrification personnes rcupres
		if(persons.isEmpty()) {
			Message.message(mainChannel, runtimeData, new MessageBean("Aucune personne trouv\u00E9e", Message.WARNING), "viewpersons");
			return Boolean.FALSE;
		}
		
		// Ajout des personnes  la base
		Iterator i = persons.iterator();
		Vector msgs = new Vector();
		while(i.hasNext()) {
			Person tmp = (Person)i.next();
			try {
				BDDConnection.newPerson(tmp);
				msgs.add(new MessageBean(tmp.getFirstname() + " " + tmp.getName() + " ajout\u00E9", Message.INFO));
			}
			catch(SQLException e) {
				msgs.add(new MessageBean(tmp.getFirstname() + " " + tmp.getName() + " non ajout\u00E9"));
			}
		}
		Message.message(mainChannel, runtimeData, msgs, "viewpersons", new Hashtable());
		return Boolean.FALSE;
	}
}
