package org.esupportail.portal.channels.CAgenda.actions;

import java.sql.SQLException;

import org.esupportail.portal.channels.CAgenda.beans.Person;
import org.esupportail.portal.channels.CAgenda.data.BDDConnection;
import org.esupportail.portal.utils.channels.FrameWorkException;
import org.esupportail.portal.utils.channels.MainChannel;
import org.esupportail.portal.utils.channels.SubChannel;
import org.esupportail.portal.utils.channels.plugins.Message;
import org.esupportail.portal.utils.channels.plugins.MessageBean;
import org.jasig.portal.ChannelRuntimeData;
import org.jasig.portal.PortalException;

/**
 * @author mlarchet
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class AddPerson extends SubChannel {

	/**
	 * @param mainChannel
	 */
	public AddPerson(MainChannel mainChannel) {
		super(mainChannel);
	}
	
	
	public Boolean init(ChannelRuntimeData rd) throws PortalException, FrameWorkException {
		runtimeData = rd;
		
		// Rcupration des paramtres
		String name = runtimeData.getParameter("nom");
		String firstname = runtimeData.getParameter("prenom");
		String phone = runtimeData.getParameter("tel");
		String mail = runtimeData.getParameter("mail");
		
		// Vrification des paramtres
		if(name == null || firstname == null || phone == null || mail == null) {
			Message.message(mainChannel, runtimeData, new MessageBean("Erreur d'acc\u00E8 \u00E0 la page"), "default");
			return Boolean.FALSE;
		}
		
		if(name.equals("")|| firstname.equals("") || phone.equals("") || mail.equals("")) {
			Message.message(mainChannel, runtimeData, new MessageBean("Tous les renseignement sont obligatoires"), "default");
			return Boolean.FALSE;
		}
		
		// Cration de la nouvelle personne
		Person pers = new Person();
		pers.setName(name);
		pers.setFirstname(firstname);
		pers.setPhone(phone);
		pers.setMail(mail);
		
		// Enregistrement dans la base de donnes
		try {
			BDDConnection.newPerson(pers);
		}
		catch(SQLException e) {
			Message.message(mainChannel, runtimeData, new MessageBean(e.getMessage()), "default");
			return Boolean.FALSE;
		}
		Message.message(mainChannel, runtimeData, new MessageBean("Enregistrement effectu\u00E9", Message.INFO), "default");
		return Boolean.FALSE;
	}
}
