package org.esupportail.portal.channels.CGetLogin;

//A channel needs these eight classes no matter what:
import java.util.Enumeration;

import org.jasig.portal.PortalException;
import org.jasig.portal.utils.XSLT;
import org.xml.sax.ContentHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
//This is only useful if you will be using the LogService (which you should!!):
import org.jasig.portal.channels.BaseChannel;
import org.jasig.portal.security.IPerson;

/** 
*  A simple example channel for the uPortal.
*  @author Owen Gunden (nog7g@virginia.edu)
*/
public class CGetLogin extends BaseChannel {
	protected static Log log = LogFactory.getLog(CGetLogin.class);
	/** 
	*  Construct0r. 
	*/ 
	public CGetLogin() { 
	}
	
	
	/** Output channel content to the portal
	*  @param out a sax document handler
	*/
	public void renderXML(ContentHandler out) throws PortalException {	
		if(log.isDebugEnabled()) {
			log.debug("CGetLogin::renderXML()");
		}
		StringBuffer xml = new StringBuffer();
		String login="";
		IPerson userConnect = null;
		
		// Get the person object
		userConnect = staticData.getPerson();
		
		// Get the login of the person
		login = (String) userConnect.getAttribute(IPerson.USERNAME);
		Enumeration e =userConnect.getAttributes();
		Enumeration e2 =userConnect.getAttributeNames();
		while(e.hasMoreElements()){
		    String v=(String)e.nextElement().toString();
		    String k= (String)e2.nextElement().toString();
		    log.debug("Attribut : "+k+" valeur : "+v);
		}
		xml.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>"); 
	    xml.append("<login>"+login+"</login>");
	
	    // Create a new XSLT styling engine
	    XSLT xslt = new XSLT(this);
	 
	    // pass the result XML to the styling engine.
	    xslt.setXML(xml.toString());
	 
	    // specify the stylesheet selector
	    xslt.setXSL("CGetLogin.ssl","normal", runtimeData.getBrowserInfo());

	    // set the output Handler for the output.
	    xslt.setTarget(out);
	 
	    // do the deed
	    xslt.transform();
	}
}
