package org.esupportail.portal.channels.CCacheable;


import org.jasig.portal.ChannelCacheKey;
import org.jasig.portal.IChannel;
import org.jasig.portal.ChannelRuntimeData;
import org.jasig.portal.ChannelRuntimeProperties;
import org.jasig.portal.ChannelStaticData;
import org.jasig.portal.ICacheable;
import org.jasig.portal.PortalEvent;
import org.jasig.portal.PortalException;
import org.jasig.portal.utils.DocumentFactory;
import org.jasig.portal.utils.ResourceLoader;
import org.jasig.portal.utils.XSLT;
import org.xml.sax.ContentHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/** <p>CCacheable channel</p>
 * @author Marchal Julien , julien.marchal@univ-nancy2.fr
 * @version $Revision: 1.0 $
 */
public class CCacheable  implements IChannel,ICacheable
{
  private ChannelStaticData staticData = null;
  private ChannelRuntimeData runtimeData = null;
  private ChannelRuntimeProperties runtimeProperties = null;

protected static Log log = LogFactory.getLog(CCacheable.class);
	private int i = 0;

  // Emplacement du ssl
  private String sslLocation = "CCacheable.ssl";

  /** Constructs a CCacheable.
   */
  public CCacheable ()
  {
    log.debug("CCacheable : CONSTRUCTEUR");
  }


  /** Returns channel runtime properties
   * @return handle to runtime properties
   */
  public ChannelRuntimeProperties getRuntimeProperties ()
  {
    this.runtimeProperties=new ChannelRuntimeProperties ();
    log.debug("CCacheable("+this.staticData.getChannelSubscribeId()+") : getRuntimeProperties");
    return(this.runtimeProperties);
  }


  /** Processes layout-level events coming from the portal
   * @param ev a portal layout event
   */
  public void receiveEvent (PortalEvent ev)
  {
    log.debug("CCacheable("+this.staticData.getChannelSubscribeId()+") : receiveEvent : "+ev.getEventName()+" Number : "+ev.getEventNumber());
  }

  /** Receive static channel data from the portal
   * @param sd static channel data
   */
  public void setStaticData (ChannelStaticData sd) throws PortalException
  {
    this.staticData = sd;
    log.debug("CCacheable("+this.staticData.getChannelSubscribeId()+") : setStaticData");
  }

  /** Receives channel runtime data from the portal and processes actions
   * passed to it.  The names of these parameters are entirely up to the channel.
   * @param rd handle to channel runtime data
   */
  public void setRuntimeData (ChannelRuntimeData rd)  throws PortalException
  {
    this.runtimeData = rd;
    
    log.debug("CCacheable("+this.staticData.getChannelSubscribeId()+") : setRuntimeData");
  }

  /** Output channel content to the portal
   * @param out a sax document handler
   */
  public void renderXML (ContentHandler out) throws PortalException
  {
    log.debug("CCacheable("+this.staticData.getChannelSubscribeId()+") : renderXML");
    // recupre le timestamp
    String STime=(new Long(System.currentTimeMillis())).toString();

    StringBuffer xml=new StringBuffer();
//  creation d'un nouveau document XML
    xml.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>"); 
    xml.append("<content>");
    xml.append("<currentTime>"+STime+"</currentTime>");
    xml.append("<compteur>"+new Integer(i).toString()+"</compteur>");
    xml.append("</content>"); 
   
    // rendu XSLT
    XSLT xslt = new XSLT(this);
    xslt.setXML(xml.toString());
    xslt.setXSL(sslLocation, runtimeData.getBrowserInfo());
    xslt.setTarget(out);
    xslt.setStylesheetParameter("baseActionURL", runtimeData.getBaseActionURL());
    xslt.transform();
  }

  /** Genration d'une cle pour le cache
   * @param
   * @return ChannelCacheKey cle du cache
   */
  public ChannelCacheKey generateKey()  {
    ChannelCacheKey k  = new ChannelCacheKey();
    StringBuffer sbKey = new StringBuffer(1024);
    sbKey.append("org.esupportail.portal.channels.CCacheable.CCacheable : ");
    sbKey.append("userId:").append(staticData.getPerson().getID()).append(", ");
    sbKey.append("stylesheetURI:");
    try {
      String sslURI = ResourceLoader.getResourceAsURLString(this.getClass(),sslLocation);
      sbKey.append(XSLT.getStylesheetURI(sslURI, runtimeData.getBrowserInfo()));
    }
    catch (Exception e) {
      sbKey.append("not defined");
    }

    k.setKeyScope(ChannelCacheKey.SYSTEM_KEY_SCOPE);

    k.setKey(sbKey.toString());
    k.setKeyValidity(new Long(System.currentTimeMillis()));
    log.debug("CCacheable("+this.staticData.getChannelSubscribeId()+") : generateKey :  -> Cle :" + k.getKey());
    return k;
  }


  /**
   * put your documentation comment here
   * @param validity
   * @return boolean
   */
  public boolean isCacheValid(Object validity) {
    boolean cacheValid = false;

    if (validity instanceof Long) {
      Long oldtime = (Long) validity;
      // Si validity  moins de 60 secondes le cache est valide
      if (System.currentTimeMillis() - oldtime.longValue() < 30 * 1000) {
        cacheValid = true;
      }
    }

    if (cacheValid) {
        log.debug(
                                "CCacheable(" +
                                this.staticData.getChannelSubscribeId() +
                                ") : isCacheValid -> YES");     
    }
    else {
        log.debug(
                                "CCacheable(" +
                                this.staticData.getChannelSubscribeId() +
                                ") : isCacheValid -> NO");
        i++;
    }
    log.debug("Compteur : " + i);
    return cacheValid;
  }
}
