<?xml version="1.0" encoding="ISO-8859-1" ?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

<xsl:output method="html" indent="no" />

<xsl:param name="mediaPath" />

<xsl:template match="xml">

	<table border="0" width="100%" cellspacing="0" cellpadding="10">
		<tr>
			<td class="uportal-channel-table-header" nowrap="true">Filesystem</td>
			<td width="100%">&#160;</td>
		</tr>
	</table>
	<hr/>
	<br/>
	<table border="0" cellpadding="0" cellspacing="0">
		<xsl:apply-templates select="./folder" />
	</table>
			
</xsl:template>

<xsl:template match="folder">
	<tr>
		<td>&#160;</td>
		<td nowrap="true">
			<table width="100%" border="0" cellpadding="0" cellspacing="0">
				<tr>
					<td align="center" valign="absmiddle" width="20">
						<img src="{$mediaPath}folder.gif" border="0" />
					</td>
					<td class="uportal-label" nowrap="true">
						<xsl:value-of select="./@name" />
					</td>
					<td>&#160;</td>
				</tr>
				<xsl:apply-templates select="./file" />
				<xsl:apply-templates select="./folder" />	
			</table>
		</td>
		<td width="100%">&#160;</td>
	</tr>		
</xsl:template>

<xsl:template match="file">
	<tr>
		<td>&#160;</td>
		<td nowrap="true">
			<table width="100%" border="0" cellpadding="0" cellspacing="0">
				<tr>
					<td align="center" valign="absmiddle" width="20">
						<img src="{$mediaPath}file.gif" border="0" />
					</td>
					<td class="uportal-label" nowrap="true">
						<xsl:value-of select="./@name" /> - <xsl:value-of select="./@description" />
					</td>
					<td>&#160;</td>
				</tr>
			</table>
		</td>
		<td width="100%">&#160;</td>
	</tr>
</xsl:template>

</xsl:stylesheet>