package org.esupportail.portlet.spring.dao;

import java.util.List;

import org.esupportail.portlet.spring.beans.Entry;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;

public class DataServiceHibernate extends HibernateDaoSupport implements DataService {

    /**
     * Retourne la liste des adresses
     * @return
     */
    @SuppressWarnings("unchecked")
    public List<Entry> getAddresses() {
	return (List<Entry>)getHibernateTemplate().loadAll(Entry.class); 
    }

    /**
     * Retourne une adresse
     * @param id
     * @return
     */
    public Entry getAddress(String id) {
	return (Entry)getHibernateTemplate().load(Entry.class, id);
    }

    /**
     * Ajoute une adresse
     * @param entry
     */
    public void addAddress(Entry entry) {
	getHibernateTemplate().persist(entry);
    }

    /**
     * Met  jour une adresse
     * @param entry
     */
    public void updateAddress(Entry entry) {
	getHibernateTemplate().update(entry);
    }

    /**
     * Supprime une adresse
     * @param id
     */
    public void deleteAddress(Entry entry) { 
	getHibernateTemplate().delete(entry);
    }
}