package org.esupportail.portlet.spring.dao;

import java.util.List;

import org.esupportail.portlet.spring.beans.Entry;
import org.springframework.orm.ibatis.SqlMapClientTemplate;

public class DataServiceIbatis implements DataService {

    private SqlMapClientTemplate sqlMapClientTemplate;

    /**
     * Positionne le service Ibatis
     * @param sqlMapClientTemplate
     */
    public void setSqlMapClientTemplate(SqlMapClientTemplate sqlMapClientTemplate) {
	this.sqlMapClientTemplate = sqlMapClientTemplate;
    }

    /**
     * Retourne la liste des adresses
     * @return
     */
    @SuppressWarnings("unchecked")
    public List<Entry> getAddresses() {
	return (List<Entry>) sqlMapClientTemplate.queryForList("getEntries", null);
    }

    /**
     * Retourne une adresse
     * @param id
     * @return
     */
    public Entry getAddress(String id) {
	return (Entry)sqlMapClientTemplate.queryForObject("getEntry", id);
    }

    /**
     * Ajoute une adresse
     * @param entry
     */
    public void addAddress(Entry entry) {
	sqlMapClientTemplate.insert("addEntry", entry);
    }

    /**
     * Met  jour une adresse
     * @param entry
     */
    public void updateAddress(Entry entry) {
	sqlMapClientTemplate.update("updateEntry", entry);
    }

    /**
     * Supprime une adresse
     * @param entry
     */
    public void deleteAddress(Entry entry) {
	sqlMapClientTemplate.delete("deleteEntry", entry);
    }
}
