package org.esupportail.portlet.spring.domain;

import java.util.List;

import org.esupportail.portlet.spring.beans.Entry;
import org.esupportail.portlet.spring.dao.DataService;

public class DomainServiceDao implements DomainService {

    private DataService dataService;

    /**
     * Retourne la liste des adresses
     * @return
     */
    public List<Entry> getAddresses() {
	return dataService.getAddresses();
    }

    /**
     * Retourne une adresse
     * @param id
     * @return
     */
    public Entry getAddress(String id) {
	return dataService.getAddress(id);
    }

    /**
     * Ajoute une adresse
     * @param entry
     */
    public void addAddress(Entry entry) {
	dataService.addAddress(entry);
    }

    /**
     * Met  jour une adresse
     * @param entry
     */
    public void updateAddress(Entry entry) {
	dataService.updateAddress(entry);
    }

    /**
     * Supprime une adresse
     * @param entry
     */
    public void deleteAddress(Entry entry) {
	dataService.deleteAddress(entry);
    }

    /**
     * Positionne le service de donnes
     * @param am
     */
    public void setDataService(DataService dataService) {
	this.dataService = dataService;
    }
}