package org.esupportail.portlet.spring.domain;

import java.util.Iterator;
import java.util.List;

import org.esupportail.portlet.spring.beans.Entry;

public class DomainServiceStatic implements DomainService {

    private List<Entry> addresses;

    /**
     * Constructeur
     */
    public DomainServiceStatic() {
    }

    /**
     * Positionne la liste des adresses
     * @param addresses
     */
    public void setAddresses(List<Entry> addresses) {
	this.addresses = addresses;
    }

    /**
     * Retourne la liste des adresses
     * @return
     */
    public List<Entry> getAddresses() {
	return addresses;
    }

    /**
     * Retourne une adresse
     * @param id
     * @return
     */
    public Entry getAddress(String id) {
	for(Entry e : addresses) {
	    if(e.getId().equals(id)) {
		return e;
	    }
	}
	return null;
    }

    /**
     * Ajoute une adresse
     * @param entry
     */
    public void addAddress(Entry entry) {
	addresses.add(entry);
    }

    /**
     * Met  jour une adresse
     * @param entry
     */
    public void updateAddress(Entry entry) {
    }

    /**
     * Supprime une adresse
     * @param id
     */
    public void deleteAddress(Entry entry) {
	Iterator<Entry> iterator = addresses.iterator();
	while (iterator.hasNext()) {
	    Entry element = iterator.next();
	    if (element.getId() == entry.getId()) {
		iterator.remove();
	    }
	}
    }
}
