package org.esupportail.portlet.spring.web;

import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletRequest;

import org.esupportail.portlet.spring.beans.Entry;
import org.esupportail.portlet.spring.domain.DomainService;
import org.springframework.validation.BindException;
import org.springframework.web.portlet.mvc.SimpleFormController;

public class AddEntryController extends SimpleFormController {

    private DomainService domainService;

    /**
     * Positionne le service mtier
     * @param domainService
     */
    public void setDomainService(DomainService domainService) {
	this.domainService = domainService;
    }

    /**
     * Traite le formulaire une fois valid
     * @param request
     * @param response
     * @param o
     * @param e
     */
    protected void onSubmitAction(ActionRequest request, ActionResponse response, Object o, BindException e) throws Exception {
	Entry entry = (Entry)o;
	System.out.println("Hello");
	domainService.addAddress(entry);
	response.setRenderParameter("action", "home");
    }

    /**
     * Instancie l'objet sur lequel le formulaire sera mapp
     * @param request
     * @return
     */
    protected Object formBackingObject(PortletRequest request) throws Exception {
	return new Entry();
    }
}