package org.esupportail.portlet.spring.web;

import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;

import org.esupportail.portlet.spring.beans.Entry;
import org.esupportail.portlet.spring.domain.DomainService;
import org.springframework.web.portlet.mvc.AbstractController;

public class DelEntryController extends AbstractController {

    private DomainService domainService;

    /**
     * Positionne le service mtier 
     * @param domainService
     */
    public void setDomainService(DomainService domainService) {
	this.domainService = domainService;
    }

    /**
     * Traitement 'Action'
     * @param request ActionRequest la requte
     * @param response ActionResponse la rponse
     */
    protected void handleActionRequestInternal(ActionRequest request, ActionResponse response) throws Exception {
	String id = request.getParameter("id");

	Entry entry = domainService.getAddress(id);
	domainService.deleteAddress(entry);
	response.setRenderParameter("action", "home");
    }
}