package org.esupportail.portlet.spring.web;

import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;

import org.esupportail.portlet.spring.domain.DomainService;
import org.springframework.web.portlet.ModelAndView;
import org.springframework.web.portlet.mvc.AbstractController;

public class HomeController extends AbstractController {

    private DomainService domainService;

    /**
     * Positionne le service mtier 
     * @param domainService
     */	
    public void setDomainService(DomainService domainService) {
	this.domainService = domainService;
    }

    /**
     * Traitement 'Render'
     * @param request RenderRequest la requte
     * @param response RenderResponse la rponse
     */
    protected ModelAndView handleRenderRequestInternal(RenderRequest request, RenderResponse response) throws Exception {
	return new ModelAndView("home", "addresses", domainService.getAddresses());
    }
}