package org.esupportail.portlet.spring.web;

import org.esupportail.portlet.spring.beans.Entry;
import org.springframework.validation.Errors;
import org.springframework.validation.ValidationUtils;
import org.springframework.validation.Validator;

public class UpdateEntryValidator implements Validator {

    /**
     * Indique le type d'objet support par ce validator
     * @param clazz
     * @return
     */
    public boolean supports(Class clazz) {
	return clazz.equals(Entry.class);
    }

    /**
     * Validation d'une entre
     * @param 
     */
    public void validate(Object o, Errors errors) {
	Entry e = (Entry)o;
	validateName(e.getName(), errors);
	validateFirstName(e.getFirstName(), errors);
	validateMail(e.getMail(), errors);
    }

    /**
     * Valide le nom
     * @param name
     * @param errors
     */
    private void validateName(String name, Errors errors) {
	ValidationUtils.rejectIfEmpty(errors, "name", "name.required", "Le nom est obligatoire");
    }

    /**
     * Valide le prnom
     * @param firstName
     * @param errors
     */
    private void validateFirstName(String firstName, Errors errors) {
	ValidationUtils.rejectIfEmpty(errors, "firstName", "firstName.required", "Le prnom est obligatoire");
    }

    /**
     * Valide le mail
     * @param mail
     * @param errors
     */
    private void validateMail(String mail, Errors errors) {
	ValidationUtils.rejectIfEmpty(errors, "mail", "mail.required", "L'adresse est obligatoire");
	if(!mail.equals("")) {
	    if(!mail.matches("^\\w[_\\-\\.\\w]*\\@\\w[_\\-\\.\\w]*\\.(\\w){2,3}$")) {
		errors.rejectValue("mail", "mail.invalid", "Adresse invalide");
	    }
	}
    }
}
