<%@ include file="/WEB-INF/jsp/include.jsp" %>

<spring:hasBindErrors name="entry">
	<p class="portlet-msg-error">Merci de corriger les erreurs suivantes :</p>
	<ul>
		<spring:bind path="entry.*">
			<c:forEach items="${status.errorMessages}" var="error">
				<li><c:out value="${error}"/></li>
			</c:forEach>
		</spring:bind>
	</ul>
</spring:hasBindErrors>

<form method="post" action="<portlet:actionURL><portlet:param name="action" value="updateEntry" /></portlet:actionURL>">
	<table border="0" cellspacing="0" cellpadding="1">
		<tr>
			<td class="portlet-font" nowrap="true">Identifiant :</td>
			<td class="portlet-font" nowrap="true">
				<input type="hidden" name="id" value="${entry.id}" />
				<c:out value="${entry.id}" /></td>
			<td>&nbsp;</td>
		</tr>
		<tr>
			<td class="portlet-font" nowrap="true">Nom :</td>
			<td nowrap="true">
				<spring:bind path="entry.name">
					<input class="portlet-form-input-field" type="text" name="${status.expression}" value="${status.value}" />
					<span class="portlet-msg-error">${status.errorMessage}</span>
				</spring:bind>
			</td>
			<td class="portlet-section-text">(Obligatoire)</td>
		</tr>
		<tr>
			<td class="portlet-font" nowrap="true">Prnom :</td>
			<td nowrap="true">
				<spring:bind path="entry.firstName">
					<input class="portlet-form-input-field" type="text" name="${status.expression}" value="${status.value}" />
					<span class="portlet-msg-error">${status.errorMessage}</span>
				</spring:bind>
			</td>
			<td class="portlet-section-text">(Obligatoire)</td>
		</tr>
		<tr>
			<td class="portlet-font" nowrap="true">Mail :</td>
			<td nowrap="true">
				<spring:bind path="entry.mail">
					<input class="portlet-form-input-field" type="text" name="${status.expression}" value="${status.value}" />
					<span class="portlet-msg-error">${status.errorMessage}</span>
				</spring:bind>
			</td>
			<td class="portlet-section-text">(Obligatoire)</td>
		</tr>
	</table>
	<br/>
	<button class="portlet-form-button" type="submit">Valider</button>
</form>
<a href="<portlet:renderURL><portlet:param name="action" value="home" /></portlet:renderURL>">Revenir  la page d'accueil</a>