import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.Socket; 
import javax.net.ssl.SSLSocketFactory;

public class testHTTPS  {
	public static String TARGET_HTTPS_SERVER = "";
	public static int    TARGET_HTTPS_PORT   = 443;
	public static String    TARGET_HTTP_VER   = "HTTP/1.0";
	public static String    TARGET_ENCODING   = "ISO-8859-1";
	
	public static void main(String[] args) throws Exception {
		if (args.length < 1){
			System.err.println("Utilisation \"testHTTPS HOST [PORT] [HTTP_VERSION] [ENCODING]\"");
			return;
		}
		
		if(args[0] != null && !"".equals(args[0])) {
			TARGET_HTTPS_SERVER = args[0];
		} else {
			System.err.println("Erreur : Vous devez entrer un nom de host");
			return;
		}
		
		if(args.length > 1 && args[1] != null && !"".equals(args[1])) {
			TARGET_HTTPS_PORT = Integer.valueOf(args[1]);
		} 
		
		if(args.length > 2 && args[2] != null && !"".equals(args[2])) {
			TARGET_HTTP_VER = args[2];
		} 
		
		if(args.length > 3 && args[3] != null && !"".equals(args[3])) {
			TARGET_ENCODING = args[3];
		} 
		
		
		System.out.println("Test https :");
		System.out.println("  HOST : " + TARGET_HTTPS_SERVER);
		System.out.println("  PORT : " + TARGET_HTTPS_PORT);
		System.out.println("  HTTP VERSION : " + TARGET_HTTP_VER);
		System.out.println("  ENCODING : " + TARGET_ENCODING);
		System.out.println("");
		System.out.println("");
		
		System.out.println("******** DEBUT DU TEST ******** ");
		Socket socket = SSLSocketFactory.getDefault().createSocket(TARGET_HTTPS_SERVER, TARGET_HTTPS_PORT);
		try {
			Writer out = new OutputStreamWriter(socket.getOutputStream(), TARGET_ENCODING);
			out.write("GET / " + TARGET_HTTP_VER + "\r\n");
			out.write("Host: " + TARGET_HTTPS_SERVER + ":" + TARGET_HTTPS_PORT + "\r\n");
			out.write("Agent: SSL-TEST\r\n");
			out.write("\r\n");
			out.flush();
			BufferedReader in = new BufferedReader(
					new InputStreamReader(socket.getInputStream(), TARGET_ENCODING));
			String line = null;
			while ((line = in.readLine()) != null) {
				System.out.println(line);
			}
			
			//			System.exit(0);
		} finally {
			socket.close();
			System.out.println("******** FIN DU TEST ******** ");
			System.out.println("");
			System.out.println("Test https :");
			System.out.println("  HOST : " + TARGET_HTTPS_SERVER);
			System.out.println("  PORT : " + TARGET_HTTPS_PORT);
			System.out.println("  HTTP VERSION : " + TARGET_HTTP_VER);
			System.out.println("  ENCODING : " + TARGET_ENCODING);
		}
	}
}
