<%@ page session="false" %>
<%
  String serviceId = (String) request.getAttribute("serviceId");
  String token = (String) request.getAttribute("token");
  String service = null;
  boolean safari = true;  // will set this below
  if (serviceId.indexOf('?') == -1)
    service = serviceId + "?ticket=" + token;
  else
    service = serviceId + "&ticket=" + token;

  // Avoid Javascript embedded in the URL
  service =
    edu.yale.its.tp.cas.util.StringUtil.substituteAll(service, "\n", "");
  service =
    edu.yale.its.tp.cas.util.StringUtil.substituteAll(service, "\r", "");
  service =
    edu.yale.its.tp.cas.util.StringUtil.substituteAll(service, "\"", "");
  service =
    edu.yale.its.tp.cas.util.StringUtil.substituteAll(service, "<", "%3C");
  service =
    edu.yale.its.tp.cas.util.StringUtil.substituteAll(service, ">", "%3E");

  // Check for invalid characters or a badly formed URL
  // By preventing newlines and <script> tags, the previous checks solve all
  // known problems. There is no simple function to %xx escape all the
  // remaining special or invalid characters, but the URI class will
  // throw an exception if the service string does not confirm to the W3C
  // standards. Unfortunately, for existing CAS deployments we cannot guarantee
  // that one of your existing services does not use an invalid unescaped
  // character in the service string. You may want to disable this check when
  // merging with an existing CAS2, while new users deploying for the first time
  // should leave it in and force new services to get the damn URL right.
  if (false) {   // change to true to enable the test
    try {
        new java.net.URI(service).toURL().toString();
    } catch (Exception e) { // URISyntaxException or MalformedURLException
        service = "success.jsp"; // if service invalid, don't go there
    }
  }

  // Set Refresh header on initial login only if user isn't using Safari.
  // Fixes security bug where Safari would repost login credentials to the
  // web application rather than to CAS.
  if (((String)request.getAttribute("first")).equals("false")
    || request.getHeader("User-Agent") == null
    || request.getHeader("User-Agent").indexOf("Safari") == -1) {
    safari = false;
  }
%>
<html>
<head>
<title>Yale Central Authentication Service</title>
<% if (!safari) { %>
<script>
  window.location.href="<%= service %>";
</script>
<% } %>
</head>

<body bgcolor="#0044AA" link="#ffffff" alink="#ffffff" vlink="#ffffff">
<% if (!safari) { %>
<noscript>
<% } %>
  <p>Login successful.</p>
  <p>
   Click <a href="<%= service %>">here</a>
   to access the service you requested.
  </p>
<% if (!safari) { %>
</noscript>
<% } %>
</body>

</html>