<%@ taglib prefix="cas" uri="http://www.yale.edu/its/tp/castools" %>
<%@ page import="java.util.*"%>
<%@ page import="fr.univrennes1.cri.calendar.*"%>
<%@ page import="org.apache.log4j.*"%>
<%@ page errorPage = "page-erreur.jsp" %>
<%
Logger logger = Logger.getLogger("index.jsp");
if (request.getParameter("service") != null) {
	logger.debug("Parametre service=" + request.getParameter("service") + " mis en session");
  	session.setAttribute("service", (String)request.getParameter("service"));
}
%>
<cas:auth id="user" scope="session"/>
<%
 /**
 * description
 * Cette page permet l'autentification par CAS, cre un cookie
 * contenant une cl.
 * et redirige vers l'application SUN ONE dsire
 * findescription
 */
 /**
 * service
 * type: String
 * desc: URL de redirection aprs autentification.
 */
/**
 * user
 * type: String
 * desc: login de l'utilisateur.
 */
/** ht
 * type: HashtableSSO
 * desc: Hashtable stockant les objets SOT.
 */
/** key
 * type: String
 * desc: Cl gnre alatoirement.
*/
/**
 * addr
 * type: String
 * desc: adresse ip de l'utilisateur.
*/
/**
 * datSys
 * type: long
 * desc: date systme en millisecondes.
*/
/**
 * cookieName
 * type: String
 * desc: Nom du cookie correspondant  la concatnation de ssoApPrefix et de appId.
*/
/**
 * infoUser
 * type: Sot
 * desc: Objet contenant les informations de l'utilisateur (uid, ip, date, cl).
*/
/*Cl gnre alatoirement*/
String key = Outil.genAleaTicket();
/*adresse ip du client*/
String addr = request.getRemoteAddr();
logger.debug("Adresse ip client = "+addr);
/*Rcupration du nom de domaine du cookie dans le fichier de config*/
String domain = ConfigSSO.getInstance().getDomain();
logger.debug("Nom de domaine du cookie = "+domain);
/*Date systeme en millisecondes*/
long datSys = System.currentTimeMillis();
/*Nom du cookie en concatenant ssoApPrefix et appId du fichier de config*/
String cookieName = ConfigSSO.getInstance().getSsoApPrefix()+"-"+ConfigSSO.getInstance().getAppId();
logger.debug("Nom du cookie = "+cookieName);
/*Cration du cookie*/
Cookie cook1 = new Cookie(cookieName,key);
cook1.setPath("/");
cook1.setDomain(domain);
/*Envoi du cookie chez l'utilisateur*/
response.addCookie(cook1);
/*Stock un objet Sot dans la Hashtable avec les informations de l'utilisateur*/
Sot infoUser = new Sot(key,(String)session.getAttribute("user"), addr, datSys);
logger.debug("Objet Sot Cre");
HashtableSSO.getInstance().put(key,infoUser);
logger.debug("Objet Sot mis en Hashtable");
/*redirection vers l'URL passe en paramtre (service)*/
String redirectURL = (String)session.getAttribute("service");
if (redirectURL != "" || redirectURL != null){
response.sendRedirect(response.encodeURL(redirectURL));
logger.debug("Redirection vers : "+redirectURL);
}
%>
