/**
 * @author S.Gougeon
 * date : 7 janv. 2004
 * Centre de Ressousrces Informatiques
 * Universit de Rennes 1
 * 
 * 
 * Cette classe cre un objet SOT, correspondant donnes
 * de l'utilisateur (cl, ip, date, login). Cet objet sera stock
 * dans une hashtable afin de verifier, par comparaison, si cet utilisateur
 * est bien autentifi
 */
package fr.univrennes1.cri.calendar;


public class Sot {

private String key;
private String uid;
private String ip;
private long time;
 	
/**
 * Constructeur basic
 *
 */
	public Sot(){
		key = "";
		uid = "";
		ip = "";
		time = 0;		
	}
	
/**
 * Constructeur
 * 
 * @param num cl gnre alatoirement
 * @param user login de l'utilisateur
 * @param ip2 adresse ip de l'utilisateur
 * @param date equivalent en millisecondes de la date de demande d'autentification.
 */	
	public Sot(String num, String user, String ip2, long date){
		key = num;
		uid = user;
		ip = ip2;
		time = date;		
	}
	
	
/**
 * @return l'adresse ip de l'objet SOT
 */
public String getIp() {
	return ip;
}

/**
 * @return la date en secondes  laquelle l'objet SOT a t cre
 */
public long getTime() {
	return time;
}

/**
 * @return la cl gnre alatoirement
 */
public String getKey() {
	return key;
}

/**
 * @return le login de l'utilisateur
 */
public String getUid() {
	return uid;
}

/**
 * @param string ip de l'utilisateur
 */
public void setIp(String string) {
	ip = string;
}

/**
 * @param date date en seconde de creation de l'objet SOT
 */
public void setTime(long date) {
	time = date;
}

/**
 * @param string cl gnre alatoirement
 */
public void setKey(String string) {
	key = string;
}

/**
 * @param string login de l'utilisateur
 */
public void setUid(String string) {
	uid = string;
}

}