package fr.univrennes1.cri.calendar;
import org.apache.log4j.*;

import java.io.IOException;
import java.util.*;
import javax.servlet.jsp.JspException;

/**
 * @author S.Gougeon
 * date : 15 janv. 2004
 * Centre de Ressources Informatiques
 * Universit de Rennes 1
 * 
 */
public class Clean extends Thread {

Logger logger = Logger.getLogger("Clean.java");

private String _SOTCleanTime = null;
	Timer t = null;

	/**
	 * Cette fonction est le point d'entr de la classe, il faut imperativement passer par
	 * cette mthode et ne pas en appeler une autre directement.
	 * Elle initialise le timer et declenche la TimerTask CleanHashtable.
	 * 
	 * @throws NumberFormatException
	 * @throws IOException
	 * @throws JspException
	 */
	public void remind () throws NumberFormatException, IOException, JspException{
		logger.info("Lancement du nettoyage de la Hashtable");
		t = new Timer();
		t.schedule(CleanHashtable,0,((int)(Integer.parseInt(ConfigSSO.getInstance().getSOTCleanTime()))*1000));
	}
	public void kill() {
		t.cancel();
	}

TimerTask CleanHashtable = new TimerTask(){
/**
 * Classe anonyme de la mthode TimerTask()
 * Si la date systme est superieure  la date de cration des objets Sot ajout au temps de validation des objets Sot (cf fichier de config socp.xml)
 * alors l'objet est supprim de la Hashtable. 
 */
	public void run(){
		try {
			logger.info("On rentre dans la methode run()");
			//Rcupration des objets de la Hashtable dans un tableau
			Object[] hashtableObj = HashtableSSO.getInstance().values().toArray();
			//Parours du tableau d'objets Sot
			for (int i=0;i<hashtableObj.length ;i++){
				if (logger.isDebugEnabled()) {
				logger.debug("On rentre pour la "+i+" fois dans le for");
				}
				Sot verif = (Sot)hashtableObj[i];
				//date de cration de l'objet Sot + temps de validation de l'objet = timeIsGood
				long timeIsGood = verif.getTime()+((long)(Integer.parseInt(ConfigSSO.getInstance().getSOTValidationTime())))*1000;
				//Si la date systme est superieure  la date de cration des objets Sot ajout au temps de validation des objets Sot (cf fichier de config socp.xml) alors l'objet est supprim de la Hashtable.
				if( timeIsGood <= System.currentTimeMillis()){
					//Suppression de l'objet Sot de la hashtable
					HashtableSSO.getInstance().remove(verif.getKey());
					if (logger.isDebugEnabled()) {
						logger.debug("Suppression de l'objet Sot dans la hashtable, cl= "+ verif.getKey()); 
					}//fin de if 
				}//fin de if
			}//fin de for
		}//fin du try
		catch (Exception e) {
			// TODO: handle exception
			logger.info("Erreur methode run() du thread Clean.class"+e);
		}//fin du catch
	}//fin de la methode run
};//fin de la classe anonyme
}//fin de la classe Clean
