package fr.univrennes1.cri.calendar;

/**
 * @author S.Gougeon
 * date : 7 janv. 2004
 * Centre de Ressousrces Informatiques
 * Universit de Rennes 1
 * 
 * Cette classe permet de lire le fichier de cofiguration
 * properties/configSSO.xml et d'en retirer les informations.
 * Cette classe utilise Digester.
 * 
 */

import java.net.*;
import java.io.IOException;
import javax.servlet.jsp.JspException;
import org.apache.commons.digester.Digester;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ConfigSSO {
	
	private static ConfigSSO singleton = null;
	private String appId = null;
	private String ssoApPrefix = null;
	private String SOTValidationTime = null;
	private String SOTCleanTime = null;
	private String domain = null;

/**
 * constructeur
 * @throws IOException
 * @throws JspException
 */
	public ConfigSSO()
		throws IOException, JspException
	{
		try
		{
			Class requestingClass = getClass();
			URL resourceURL = requestingClass.getResource("/properties/socp.xml");
			if(resourceURL == null)
				throw new JspException("socp.xml does not exist ");
			Digester dig = new Digester();
			dig.push(this);
			dig.addCallMethod("sso", "addRoot", 5);
			dig.addCallParam("sso", 0, "appId");
			dig.addCallParam("sso", 1, "ssoPrefix");
			dig.addCallParam("sso", 2, "SOTValidationTime");
			dig.addCallParam("sso", 3, "SOTCleanTime");
			dig.addCallParam("sso", 4, "domain");
			dig.parse(new InputSource(resourceURL.toExternalForm()));
		}
		catch(IOException e)
		{
			throw new JspException("Impossible to load file socp.xml : " + e);
		}
		catch(SAXException e)
		{
			throw new JspException(e);
		}
	}

/**
 * Cette fonction affecte les instances de la classe avec les valeurs recupres du fichier
 * de configuration properties/ConfigSSO.xml
 * @param _appId identifiant, prfixe du cookie de l'application
 * @param _SSOPrefix identifiant unique de l'application, suffixe du cookie de l'application
 * @param _SOTValidTime dure de validit du cookie en seconde
 * @param _SOTCleanTime temps entre deux nettoyage de la Hashtable en seconde
 * @param _domain domaine de validit du cookie
 */
	public void addRoot(String _appId, String _SSOPrefix, String _SOTValidationTime, String _SOTCleanTime, String _domain)
	{
		appId = _appId;
		ssoApPrefix = _SSOPrefix;
		SOTValidationTime = _SOTValidationTime ;
		SOTCleanTime = _SOTCleanTime ;
		domain = _domain;
	}

/**
 * 
 * @return singleton du type ConfigSSO
 * @throws IOException
 * @throws JspException
 */
	public static ConfigSSO getInstance()
		throws IOException, JspException
	{
		if(singleton == null)
			singleton = new ConfigSSO();
		return singleton;
	}


	/**
	 * @return l'identifiant unique de l'application
	 */
	public String getAppId() {
		return appId;
	}

	/**
	 * @return temps en seconde de la dure de validit du cookie
	 */
	public String getSOTValidationTime() {
		return SOTValidationTime;
	}

	/**
	 * @return identifiant, prfixe du cookie de l'application
	 */
	public String getSsoApPrefix() {
		return ssoApPrefix;
	}

	/**
	 * @return nom de domaine de l'application
	 */
	public String getDomain() {
		return domain;
	}

	/**
	 * @return temps entre deux nettoyage de la Hashtable en seconde
	 */
	public String getSOTCleanTime() {
		return SOTCleanTime;
	}

}
