package org.esupportail.portal.channels.CAnnuaire;

import org.jasig.portal.*; 
import org.jasig.portal.services.LogService;
import org.jasig.portal.utils.*;
import org.xml.sax.*;

/** 
 * <p>Titre : CAnnuaire</p>
 * <p>Description : Formulaire de recherche dans l'annuaire</p>
 * <p>Copyright : Copyright (c) 2003</p>
 * <p>Socit : N2</p>
 * @author Sbatien GAUDIN
 * @version 1.0
 */

public class CAnnuaire
    implements IChannel {


	/****************************/
	/*Variables de programmation*/
	/****************************/
	
	private String _annuaireEnCours = null;

	private final String etatFormulaire = "Form"; 
	private final String etatTableauRes = "Tab"; 
	private final String etatFicheRes   = "Fic"; 
	private final String etatRecherche = "Rec"; 
	

	private final String noError   = ""; 
	

	/****************************/
	/*Variables de configuration*/
	/****************************/
	
	private String etat = null;

	private String _error = noError;
	
	/*fichier de configuration*/  
	private final static String _configFilePath = "/properties/channels/org_esup/CAnnuaire.xml"; 

	/*feuille ssl*/
	private final static String _xslLocation = "CAnnuaire.ssl"; 
	

	/*interface utilisateur*/
	private userInterface _UI;
	  
	ChannelStaticData staticData = null;
	ChannelRuntimeData runtimeData = null;
	
	private config _conf;
	
	//Construire le cadre
	public CAnnuaire() {	
		_conf = new config(_configFilePath) ;
		_UI = new userInterface(_conf); 
	}


  public ChannelRuntimeProperties getRuntimeProperties() {
    return new ChannelRuntimeProperties();
  }

  /** Processes layout-level events coming from the portal
   * @param ev a portal layout event
   */ 
  public void receiveEvent(PortalEvent ev) {
  }

  /** Receive static channel data from the portal
   * @param sd static channel data
   */
  public void setStaticData(ChannelStaticData sd) {
    this.staticData = sd;
    
	String serveurAuthorise = sd.getParameter("serverView");	
	if ( (serveurAuthorise==null) || (serveurAuthorise=="") )serveurAuthorise="*";
	_UI.setServerView(serveurAuthorise); 
  }

  /** Receives channel runtime data from the portal and processes actions
       * passed to it.  The names of these parameters are entirely up to the channel.
   * @param rd handle to channel runtime data
   */
  public void setRuntimeData(ChannelRuntimeData rd) {
    this.runtimeData = rd;
    
	_error = noError;
    
	etat = rd.getParameter("etat"); 
	
	if (etat==null){
		etat = etatFormulaire;
	}
	
	_annuaireEnCours = rd.getParameter("annuaire"); 
	if (_annuaireEnCours==null){
		_annuaireEnCours = _UI.getServerWork(); 
	}	

	if (_annuaireEnCours==null){
		_annuaireEnCours = _conf.getDefaultServeurKey(); 
	}	
  } 

  /** Output channel content to the portal
   * @param out a sax document handler
   */
  public void renderXML(ContentHandler out) throws PortalException {
    int nbRes= 0;
	
	
	String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n<RACINE>\n"; 
	if (_annuaireEnCours!=null){
		if( (etat.equals(etatFormulaire)) || (etat.equals("refresh")) ){

			xml += _UI.getForm(_annuaireEnCours);   
			etat = etatFormulaire;
		}
		else {
			boolean allowSearch = false;
			if (etat.equals("detail")){
				allowSearch = _UI.updateFilterId(runtimeData.getParameter("id"));
			}
			else{   		 
				allowSearch = _UI.updateFilter(runtimeData.getParameters());
			}
			if (!allowSearch){	
				xml += "<ALERT>WARN_FORM_NOT_FILLED</ALERT>\n";	
				etat = etatFormulaire;
				xml += _UI.getForm(_annuaireEnCours); 
			}
			else{
				xml += _UI.getResultXml();  
			}
		}
	}
	else{
		xml += "<ALERT>WARN_CONFIG_NOT_FOUND</ALERT>\n";	
		etat = etatFormulaire;
	}
	xml += "</RACINE>\n";  

   /*traitement de la chaine XML*/
    XSLT xslt = new XSLT(this);
	xslt.setXML(xml);

    /*Affectation de la feuille XSL en fonction du nombre de rsultat*/
	String feuille = new String();
    if (etat.equals(etatFormulaire)){
		feuille="form"; 
		etat = "recherche";
    }
    else{ 
		
		nbRes = _UI.getNbReponse(); 
		
    	if (nbRes==0){
    		feuille = "vide"; 
			etat = etatFicheRes;
    	}
    	else if ( (nbRes>0) && (nbRes<=_conf.getServer(_annuaireEnCours).getDisplay().getMaxCard()) ){
    		feuille = "fiche"; 
			etat = etatFicheRes;
    	}
    	else if ( (nbRes>_conf.getServer(_annuaireEnCours).getDisplay().getMaxCard()) /*&& (nbRes<30)*/ ){
    		feuille = "tabRes"; 
			etat = etatTableauRes;
    	}

    }
	LogService.log(LogService.DEBUG,"CAnnuaire:renderXml() : \n"+xml);
    
    try{
    	xslt.setXSL(_xslLocation, feuille, runtimeData.getBrowserInfo());
    }
    catch(PortalException e){
		LogService.log(LogService.ERROR,"CAnnuaire:renderXml() : "+e.toString());
    } 
	/*Envoie des paramtres au fichierXSL*/
	xslt.setStylesheetParameter("baseActionURL", runtimeData.getBaseActionURL()); 
	xslt.setStylesheetParameter("etat", etat); 
	xslt.setStylesheetParameter("annuSelect", _annuaireEnCours); 
	if (_annuaireEnCours!=null)xslt.setStylesheetParameter("nomId", _conf.getServer(_annuaireEnCours).getQuery().getIdentifiant());
	xslt.setStylesheetParameter("numCanal", this.staticData.getChannelPublishId()); 

    xslt.setTarget(out);
    try{
    	xslt.transform();    

		LogService.log(LogService.DEBUG,xslt.toString());
    }
    catch(PortalException e){
		LogService.log(LogService.ERROR,"Une erreur est survenue lors du parsing XML/XSL : "+e.toString());
	}

  }



}
