/*
 * Cr le 6 fvr. 2004

 */
package org.esupportail.portal.channels.CAnnuaire;

/**
 * @author sgaudin 
 *
 * 
 */
import java.util.Hashtable;

import javax.naming.NamingEnumeration;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;

import javax.naming.*;

import org.jasig.portal.services.LogService;


public class LDAPHandler {

	private String[] attributes = null;
	private int maxEntries = 0;
	private String base = null;
	private String filter = null;
	private int scope = 0;
	private String url = null;
	private String bindDn = null;
	private String bindPass = null;

	public LDAPHandler() {
	}
	
	
	public void setAttributes(String[] listAttr){
		attributes = listAttr;
	}
	
	
	public void setMaxEntries(int max){
		maxEntries = max;
	}
	
	
	public void setBase(String b){
		base = b;
	}
	
	
	public void setFilter(String f){
		filter = f;
	}
	
	
	public void setScope(int s){
		scope = s;
	}
	
	
	public void setUrl(String u){
		url = u;
	}
	
	
	public NamingEnumeration search(){
		NamingEnumeration results = null;
		
	
				
		Hashtable env = new Hashtable();
		env.put(Context.INITIAL_CONTEXT_FACTORY, "com.sun.jndi.ldap.LdapCtxFactory");
		env.put(Context.PROVIDER_URL, url);
		
		/*Creation du contexte*/
		DirContext ctx;
		try	{
			ctx = new InitialDirContext(env);
		}
		catch(NamingException e) {
			LogService.log(LogService.ERROR,"LDAPHandler:search() : "+e.toString());
			return(null);
		}

		LogService.log(LogService.DEBUG,"LDAPHandler:search() : *********DEBUT*********");
		LogService.log(LogService.DEBUG,"LDAPHandler:search() : url = "+url);
		LogService.log(LogService.DEBUG,"LDAPHandler:search() : base = "+base);
		/*Prpare l'objet qui va rcuprer la rponse*/
		SearchControls sc = new SearchControls();
		for (int i=0;i<attributes.length;i++)LogService.log(LogService.DEBUG,"LDAPHandler:search() : recupere : "+attributes[i]);
		sc.setReturningAttributes(attributes);
		sc.setCountLimit(0);//sc.setCountLimit(maxEntries);
		sc.setSearchScope(scope);
		LogService.log(LogService.DEBUG,"LDAPHandler:search() : scope = "+scope);
		LogService.log(LogService.DEBUG,"LDAPHandler:search() : filtre = "+filter);
		/*Lance la recherche*/
		NamingEnumeration answer;
		
		try{
			answer = ctx.search(base,filter,sc);
		}catch(NamingException e){
			LogService.log(LogService.ERROR,"LDAPHandler:search() : "+e.toString());
			try{	
			ctx.close();  
			}catch(NamingException f){
				LogService.log(LogService.ERROR,"LDAPHandler:search() : "+f.toString());
				return(null);
			}	        
			return(null);
		}
			
		try{	
		ctx.close();  
		}catch(NamingException e){
			LogService.log(LogService.ERROR,"LDAPHandler:search() : "+e.toString());
			return(null);
		}	    
		
		LogService.log(LogService.DEBUG,"LDAPHandler:search() : *********FIN*********");
		
					
		return(answer);
	}
	
	
	public void close(){
		
	}
	
	
			
			
}
