/*
 * Created on 4 dc. 2003
 *
 * To change the template for this generated file go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
package org.esupportail.portal.channels.CAnnuaire;
 
/**
 * @author sgaudin
 * 
 */

import java.io.IOException;
import java.net.URL;
import java.util.*;

import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;


import org.apache.commons.digester.Digester;
import org.jasig.portal.services.LogService;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Table {

	private String _name;
	private String _type;
	private String _scope;
	private String _base;
	private String _file;
	private HashMap _listeItems;
	private String _attrCode;
	private String _attrValue;
	private String _filter;


	/**
	 * Represente l'adresse du serveur LDAP
	 */
		private String _url;

	/**
	 * Represente le Dn de la connection
	 */
		private String _bindDn;

	/**
	 * Represente le mot de passe de la connection de la connection
	 */
		private String _bindPass;

	public Table() {
		_listeItems = new HashMap();
	}

	/**
	 * @param String value
	 */
	public void addItem(String value) {
		_listeItems.put("code" + _listeItems.size(), value);
	}
	/**
	 * @param String code
	 * @param String value
	 */
	public void addItem(String code, String value) {
		if (code != null) {
			_listeItems.put(code, value);
		} else {
			this.addItem(value);
		}
	}

	public HashMap getItems() {
		return _listeItems;
	}

	public String getItem(String code) {
		return (String) _listeItems.get(code);
	}

	/**
	 * @return
	 */
	public String getFile() {
		return _file;
	}

	/**
	 * @return
	 */
	public HashMap getListeItems() {
		return _listeItems;
	}

	/**
	 * @return
	 */
	public String getName() {
		return _name;
	}

	/**
	 * @return
	 */
	public String getScope() {
		return _scope;
	}

	/**
	 * @return
	 */
	public int getScopeNum() {
		int a;
		if (_scope.equalsIgnoreCase("sub")){
			a = SearchControls.SUBTREE_SCOPE;
		}
		else{
			a = SearchControls.ONELEVEL_SCOPE;
		}
		return a;
	}

	/**
	 * @return
	 */
	public String getType() {
		return _type;
	}

	/**
	 * @param string
	 */
	public void setFile(String string) {
		_file = string;
	}

	/**
	 * @param map
	 */
	public void setListeItems(HashMap map) {
		_listeItems = map;
	}

	/**
	 * @param string
	 */
	public void setName(String string) {
		_name = string;
	}

	/**
	 * @param string
	 */
	public void setScope(String string) {
		_scope = string;
	}

	/**
	 * @param string
	 */
	public void setType(String string) {
		_type = string;
	}

	public void loadItems() {
		if (_type.equals("xml")) {
			loadItemXml();
		}
		else if (_type.equals("ldap")){
			loadItemLdap();
		}
		else if (_type.equals("static")){
			/*item ajout lors de la lecture du fichier de config*/
		}


		LogService.log(
					LogService.ERROR,
					"Table::loadItems() : nb items chargs dans "+_name+" : "+_listeItems.size());		
	}
	
	
	/**
	 * @return
	 */
	public String getFilter() {
		return _filter;
	}

	/**
	 * @param string
	 */
	public void setfilter(String __filter) {
		_filter = __filter;
	}

	
	private void loadItemXml(){
		Digester digester = new Digester();
		digester.setValidating(true);
		digester.push(this);			

		/*MONTAGE DES TABLES*/
		digester.addCallMethod("list/item","addItem",2);
		digester.addCallParam("list/item",0,"code");
		digester.addCallParam("list/item",1,"value");
			
		Class requestingClass = this.getClass();
		 //Emplacement du fichier de config  parser  partir du rpertoire classes
	   URL resourceURL =    requestingClass.getResource(_file);
		  
		try {
			digester.parse(new InputSource(resourceURL.toExternalForm()));

		} catch (IOException e) {
			LogService.log(
				LogService.ERROR,
				"Table::loadItems() : ERREUR : Impossible d'ouvrir le fichier de config :"
					+ _file
					+ "\n"
					+ e.toString());
		} catch (SAXException e) {
			LogService.log(
				LogService.ERROR,
				"Table::loadItems() : ERREUR : SAXException :\n"
					+ e.toString());
		} catch (Exception e) {
			LogService.log(
				LogService.ERROR,
				"Table::loadItems() : ERREUR : \n" + e.toString());
		}
	}

	private void loadItemLdap(){
		
		/*Met les attributs LDAP  rcuprer dans un tableau de chaines*/
		String[] attrIDs = new String [2];
		attrIDs[0] = _attrCode;
		attrIDs[1] = _attrValue;
		LDAPHandler LDAP = new LDAPHandler();
		LDAP.setUrl(_url);
		LDAP.setAttributes(attrIDs);
		LDAP.setMaxEntries(0);
		LDAP.setBase(_base);
		LDAP.setFilter(_filter);
		LDAP.setScope(this.getScopeNum());
		NamingEnumeration answer = LDAP.search();
		
		/*Parcours les rponses*/
		if (answer!=null){
			try{
				while (answer.hasMore()) {
							
					SearchResult sr;
					try{
						sr = (SearchResult)answer.next();	
						
					}
					catch(NamingException e){
						LogService.log(
							LogService.ERROR,
							"Table::loadItems() : Parcours les rponses NullPointerException : "+e.toString());
						LDAP.close();
						break;			
					}
					
					/*Parcours les attributs de la rponse*/		
					Attribute attrib = sr.getAttributes().get(attrIDs[0]);
					addItem((String)sr.getAttributes().get(attrIDs[0]).get(0),(String)sr.getAttributes().get(attrIDs[1]).get(0));
				}
			}
			catch(NullPointerException e){
				LogService.log(
					LogService.ERROR,
					"Table::loadItems() : aucune rponse : "+e.toString());
				LDAP.close();
			}	
			catch(NamingException e){
				LogService.log(
					LogService.ERROR,
					"Table::loadItems() : search : "+e.toString());
				LDAP.close();
			}
		}
	}
	/**
	 * @return
	 */
	public String getBase() {
		return _base;
	}

	/**
	 * @param string
	 */
	public void setBase(String string) {
		_base = string;
	}

	/**
	 * @return
	 */
	public String getAttrCode() {
		return _attrCode;
	}

	/**
	 * @return
	 */
	public String getAttrValue() {
		return _attrValue;
	}

	/**
	 * @param string
	 */
	public void setAttrCode(String string) {
		_attrCode = string;
	}

	/**
	 * @param string
	 */
	public void setAttrValue(String string) {
		_attrValue = string;
	}

	/**
	 * @return
	 */
	public String getBindDn() {
		return _bindDn;
	}

	/**
	 * @return
	 */
	public String getBindPass() {
		return _bindPass;
	}

	/**
	 * @return
	 */
	public String getUrl() {
		return _url;
	}

	/**
	 * @param string
	 */
	public void setBindDn(String string) {
		_bindDn = string;
	}

	/**
	 * @param string
	 */
	public void setBindPass(String string) {
		_bindPass = string;
	}

	/**
	 * @param string
	 */
	public void setUrl(String string) {
		_url = string;
	}

}
