package org.esupportail.portal.channels.CAnnuaire;
 
/** 
 * <p>Titre : CAnnuaire Config</p>
 * <p>Description : </p>
 * <p>Copyright : Copyright (c) 2003</p>
 * <p>Socit : </p>
 * @author sgaudin
 * @version 1.0
 */


import java.util.*;
import org.apache.commons.digester.*;
import org.jasig.portal.services.*;
import org.xml.sax.*;
import java.io.*;
import java.net.URL;


public class config{
  //private String ConfigFileName="";
  private HashMap _tabServer;
  private HashMap _tabTable;
  private String _defaultServeurKey = null;

  public config(String ConfigFileName){
    _tabServer = new HashMap();
	_tabTable = new HashMap();

	Digester digester = new Digester();
	digester.setValidating(true);
	digester.push(this);
	
	/*MONTAGE DES TABLES*/
	digester.addObjectCreate( "directories/tables/table", Table.class );
	digester.addSetProperties( "directories/tables/table");
		digester.addCallMethod("directories/tables/table/item", "addItem",2 );
		digester.addCallParam("directories/tables/table/item",0,"code" );
		digester.addCallParam("directories/tables/table/item",1,"value" );
	digester.addSetNext("directories/tables/table", "addTable");
	
	/*MONTAGE DES SERVEUR*/
	// pour chaque directories/directory on cree un objet directory sur lequel on va travailler tant que
	// la mthode addSetNext n'est pas appelle sur directories/directory
	digester.addObjectCreate( "directories/directory", Server.class );
	//ajout des proprits du directory
	digester.addSetProperties( "directories/directory");
	digester.addSetProperties( "directories/directory/server");
	
	
		// pour chaque directories/directory/request on cree un objet Query
		digester.addObjectCreate( "directories/directory/request", Query.class );
		//ajout des proprits du request
		digester.addSetProperties( "directories/directory/request");
	digester.addCallMethod("directories/directory/request", "setScope", 1);
	digester.addCallParam("directories/directory/request", 0,"scope");
	
		
			// pour chaque directories/directory/request/elemOfRequest on cree un objet ElmOfQuery
			digester.addObjectCreate( "directories/directory/request/elemOfRequest", ElmOfQuery.class );
			//ajout des proprits de l'elmofquery
			digester.addSetProperties( "directories/directory/request/elemOfRequest");
		
			// une fois l'objet request cree on appel Query.addElement qui ajoute un lement de requete
			digester.addSetNext("directories/directory/request/elemOfRequest", "addElement");
	
		// une fois l'objet request cree on appel Server.setQuery qui met  jour son objet Query
		digester.addSetNext( "directories/directory/request", "setQuery" );


		// pour chaque directories/directory/card on cree un objet Display
		digester.addObjectCreate( "directories/directory/card", Display.class );
		//ajout des proprits du display
		digester.addSetProperties( "directories/directory/card");

			// pour chaque directories/directory/request on cree un objet Line
			digester.addObjectCreate( "directories/directory/card/line", Line.class );
			//ajout des proprits de la line
			digester.addSetProperties( "directories/directory/card/line");
			
			digester.addCallMethod("directories/directory/card/line", "setLinktable", 1);
			digester.addCallParam("directories/directory/card/line", 0,"table");

			// une fois l'objet request cree on appel Display.addLine qui ajoute une ligne d'afcichage au display
			digester.addSetNext("directories/directory/card/line", "addLine");

		// une fois l'objet request cree on appel Server.setDisplay qui met  jour objet Display
		digester.addSetNext("directories/directory/card", "setDisplay");


	// une fois l'objet directory cree on appel this.addDirectory qui stocke l'annuaire dans un tableau
	digester.addSetNext("directories/directory", "addServer");
	URL url = config.class.getResource(ConfigFileName);
		
	if (url!=null){

		InputSource inSource = new InputSource(url.toExternalForm());
	
		try{
		  //parcours du fichier de config
		  digester.parse(inSource);	
		}
		catch (IOException e) {	
		  LogService.log(LogService.ERROR,
			  "config::config() : ERREUR : Impossible d'ouvrir le fichier de config :" +
						 ConfigFileName + "\n" + e.toString());
		}
		catch (SAXException e) {
		  LogService.log(LogService.ERROR,
						 "config::config() : ERREUR : SAXException :\n" +
						 e.toString());
		}
		catch (Exception e) {
		  LogService.log(LogService.ERROR,
						 "config::config() : ERREUR : de lecture du fichier de config\n" + e.toString());
		}
	}
	else{
		LogService.log(LogService.ERROR,
					   "config::config() : ERREUR : " + ConfigFileName +" n'existe pas.\n");
	}

  }

  public void addServer(Server s) {   
	_tabServer.put(s.getName(), s);
	if ( (_defaultServeurKey == "") || (_defaultServeurKey == null) ){
		_defaultServeurKey = s.getName();	 
	}
  }

  public void addTable(Table t) {
	 t.loadItems();
	_tabTable.put(t.getName(), t);
  }
  
  public String getDefaultServeurKey(){
  	return _defaultServeurKey;
  }
  
  public HashMap getAllServers(){
  return(_tabServer); 	
  }

  public Server getServer(String key){
	if (key!=null)return((Server)_tabServer.get(key));
	else  return(null);	
  }
  
  public HashMap getAllTables(){
  return(_tabTable); 	
  }

  public Table getTable(String key){
	return((Table)_tabTable.get(key)); 	
  }
}
