/**
 * @author sgaudin
 *
 * 
 * Cette classe est la classe centrale du package. Elle centralise els donnes de la configuration
 * excute les requtes et retourne le rsultat.
 * 
 * 
 */
package org.esupportail.portal.channels.CAnnuaire;   


import java.util.*;
import javax.naming.*;
import javax.naming.directory.*; 
import javax.naming.NamingEnumeration;

import org.jasig.portal.services.LogService;



public class userInterface {
	
	private config _myConfig;
	private String _serverView;
	private String _serverWork;
	Vector _result ;
	private Vector _eltDeFiltre = new Vector();
	private HashMap _critere = new HashMap();
	private String filtre;
	
	//
	public userInterface() {
	}	
	
	//
	public userInterface(config C) {
		this.setConfig(C);
	}
	
	public void setConfig(config C){
		_myConfig = C;		
	}
	 

/*******************************************************************************************/
/****FORMULAIRE****/
/*******************************************************************************************/	
	
/**
 * 
 * Transforme les caractres non affichable dans un fichier XML
 * 
 * @param entree : texte  formater en XML correcte
 * @return une chaine xml formate
 */	
	static String valueToXml(String entree){
		String sortie="";
		
		if (entree!=null){
			sortie = entree.replaceAll("&","&amp;");
			sortie = sortie.replaceAll("\"","'");
			sortie = sortie.replaceAll(">","&gt;");
			sortie = sortie.replaceAll("<","&lt;");
		}
		
		return sortie;
	}
	

	/**
	 * 
	 * Permet de crer le formulaire de recherche en se basant sur un annuaire
	 * 
	 * @param serveurKey : serveur sur lequel se basera la requete
	 * @return la chaine XML formant le formulaire
	 */
	public String getForm(String serveurKey){
		/*INITIALISATION DES VALEURS*/
	_serverWork=null;
	String formXml = "";
	filtre = "";
	_eltDeFiltre.clear();
	_critere = new HashMap(); 
	formXml = "<FORM>\n"; 
	if (serveurKey==null)return(formXml+"</FORM>");

	/*ECRITURE DU/DES SERVEUR(S) POTENTIEL(S)*/
	if ( (_serverView.equals("*")) || (_serverView.equals("")) ){
		//rcupration des serveurs lus en config
		HashMap listeServer = _myConfig.getAllServers();
		_serverWork = _myConfig.getDefaultServeurKey();
		for (java.util.Iterator i = listeServer.values().iterator(); i.hasNext() ;) {	
			Server s = (Server)i.next();
			formXml +=addServerToForm(s); 			
		}
	}
	else{
		//Si les serveur visibles ne sont pa spar par des virgules		
		//_serverView.matches(","); ne fonctionne pas
		if (_serverView.indexOf(",")==-1){	
			_serverWork = _serverView;
			Server monServeur = _myConfig.getServer(_serverView);
			formXml +=addServerToForm(monServeur); 	
		}
		else{
			try{
				String[] tabView = _serverView.split(",");
				_serverWork = tabView[0];	
				for (int i=0;i<tabView.length;i++){	
					formXml +=addServerToForm(_myConfig.getServer(tabView[i])); 	
				}
			}
			catch(NullPointerException e){
				LogService.log(LogService.ERROR,_serverWork+" non trouve");
			}
			
		}
	}	
	
	
	/*ECRITURE DES CHAMPS ACCESSIBLES POUR LA REQUETE*/
	if (_serverWork!=null){

		Server monServeur = _myConfig.getServer(serveurKey);
		if (monServeur!=null){
			Vector listeElt = monServeur.getQuery().getElements();
			if (listeElt!=null){
				for (java.util.Iterator j = listeElt.iterator(); j.hasNext() ;) {
					ElmOfQuery e = (ElmOfQuery)j.next(); 
					formXml +=addFieldToForm(e);
				}
			}
		}
		else{
			LogService.log(LogService.ERROR,_serverWork+" non trouve");

		}
	}

	formXml += "</FORM>\n";		

	return(formXml); 		
	}
	
	/**
	 * @param s : le serveur (Server) que l'on doit ajouter  la liste des serveurs disponibles
	 * @return le code xml pour prendre en compte ce nouveau serveur
	 */
	private String addServerToForm(Server s){
		String xml="";
		if (s!=null){
			xml ="<SERVER ";
			xml += "name=\""+s.getName()+"\" ";
			xml += "label=\""+userInterface.valueToXml(s.getTitle())+"\" ";
			xml += "/>\n";
		}
		return(xml);
	}

	/**
	 * @param e : lment (ElmOfQuery) de formulaire  ajouter.
	 * @return le code xml pour ajouter ce nouvel lment au formulaire
	 */
	private String addFieldToForm(ElmOfQuery e){
		String xml="";
		if ( (e.getType().equals("text")) || (e.getType().equals("textTable")) ){
			xml = "<FIELD name=\""+e.getNameHtml()+"\" ";
			xml += "label=\""+userInterface.valueToXml(e.getLabel())+"\" ";
			xml += "saisie=\"1\" ";
			xml += "/>\n";
			_eltDeFiltre.add(e);
		}
		else if (e.getType().equals("listTable")){
			Table table = _myConfig.getTable(e.getTable());
			if (table.getItems().size()>0){
				xml = "<FIELD name=\""+e.getNameHtml()+"\" ";
				xml += "label=\""+userInterface.valueToXml(e.getLabel())+"\" ";
				xml += "value=\""+e.getFilter()+"\" ";
				xml += "saisie=\"1\" >\n";
				Iterator i = table.getItems().values().iterator();
				Iterator k = table.getItems().keySet().iterator();
				xml += "<FIELDVALUE code=\"\" value=\"\" />\n";
				while ( (k.hasNext())  ){
					String code = (String)k.next();
					String value = (String)i.next();
					xml += "<FIELDVALUE code=\""+code+"\" value=\""+userInterface.valueToXml(value)+"\" />\n";
				}
				xml += "</FIELD>\n";
				
				_eltDeFiltre.add(e);
			}
		}
		else if (e.getType().equals("direct")){
			xml = "<FIELD name=\""+e.getNameHtml()+"\" ";
			xml += "label=\""+userInterface.valueToXml(e.getLabel())+"\" ";
			xml += "value=\""+e.getFilter()+"\" ";
			xml += "saisie=\"0\" ";
			xml += "/>\n";
			_eltDeFiltre.add(e);
		}
		return(xml);		
	}
	

/*******************************************************************************************/
/****EXECUTION REQUETE****/
/*******************************************************************************************/		

/**
 * @param value : filtre  costruire 
 * @return true ou false selon que le filtre est bien mis  jour
 *
 */ 
public boolean updateFilterId(String value){
	
	String filtreTmp = getFiltreComplet();
	
	if (value!=""){
		String id = _myConfig.getServer(_serverWork).getQuery().getIdentifiant();
		filtre="(&"+filtreTmp+"("+id+"="+value+"))";
		return true;
	}
	else{
		filtre=filtreTmp;
		return false;
	}
}


	/**
	 * 
	 * Construit le filtre de recherche
	 * 
	 * @param listeParametres : parametres recus du formulaire
	 */
	
	public boolean updateFilter(Map listeParametres){
		boolean champTextMisAJour = false;
		boolean wellFilledForm = true;
		
		filtre="(&";
		for (java.util.Iterator j = _eltDeFiltre.iterator(); j.hasNext() ;) {
			ElmOfQuery e = (ElmOfQuery)j.next(); 
			String value = (String)listeParametres.get(e.getNameHtml());
			if (e.getDelStarBool())value = value.replaceAll("\\*","");
			if ((value.length()>0)  && (value!=null) ){
				if (value.length()>=e.getMinChar()){
					/*Sauvegarde de ce nouveau critere pour l'afficher sur la feuille rsultat*/
					String[] nouvCritere = new String[2];
					nouvCritere[0] = e.getLabel();
					if ( e.getType().equals("direct") ){
						filtre +=e.updateFilter(value);			
					}
					else if ( e.getType().equals("text") ){
						champTextMisAJour = true;
						nouvCritere[1] = value;		
						_critere.put(e.getNameHtml(),nouvCritere);	
						filtre +=e.updateFilter(value);			
					}
					else if (e.getType().equals("listTable")){
						champTextMisAJour = true;
						Table T = _myConfig.getTable(e.getTable());
						nouvCritere[1] = T.getItem(value);
						_critere.put(e.getNameHtml(),nouvCritere);	
						filtre +=e.updateFilter(value);		
					}
					else if (e.getType().equals("textTable")){
						
						champTextMisAJour = true;
						Table T = _myConfig.getTable(e.getTable());
						nouvCritere[1] = value;
						_critere.put(e.getNameHtml(),nouvCritere);	
						
						/*Met les attributs LDAP  rcuprer dans un tableau de chaines*/
						String[] attrIDs = new String [1];
						attrIDs[0] = T.getAttrCode();
						LDAPHandler LDAP = new LDAPHandler();
						LDAP.setUrl(_myConfig.getServer(_serverWork).getUrl());
						LDAP.setAttributes(attrIDs);
						LDAP.setMaxEntries(e.getMaxEntries());
						LDAP.setBase(T.getBase());
						String filtreTmp = "(&"+T.getFilter()+"("+T.getAttrValue()+"="+e.getSearchValue().replaceAll("%s",value)+"))";
						LDAP.setFilter(filtreTmp);

						LDAP.setScope(T.getScopeNum());
						NamingEnumeration answer = LDAP.search();
						filtre += "(|";
						if (answer!=null){
							try{
								while (answer.hasMore()) {
					
									SearchResult sr;
									try{
										sr = (SearchResult)answer.next();
										filtre += "("+e.getFilter().replaceAll("%c",(String)sr.getAttributes().get(attrIDs[0]).get(0))+")";
										
									}
									catch(NamingException f){
										LogService.log(
											LogService.ERROR,
											"Table::loadItems() : Parcours les rponses NullPointerException : "+e.toString());
										LDAP.close();
										break;			
									}
								}
							}
							catch(NullPointerException f){
								LogService.log(
									LogService.ERROR,
									"Table::loadItems() : aucune rponse : "+e.toString());
								LDAP.close();
							}	
							catch(NamingException f){
								LogService.log(
									LogService.ERROR,
									"Table::loadItems() : search : "+e.toString());
								LDAP.close();
								wellFilledForm = false;
							}
						}	
						filtre += ")";	
					}
				}
				else{
					wellFilledForm = false;
				}
			}
		}	
		filtre +=")";

		if ( (!champTextMisAJour)||(!wellFilledForm) ){
			filtre = "";
			return false;
		}
		else{
			return true;
		}
	}
	/**
	 * 
	 * Execute la requete
	 * 
	 * @return L'ensemble des personnes rusltat sous forme de Vector
	 */
	public boolean executeQuery(){
		_result = new Vector();
		
		if (filtre!="" ){	
			String[] attrIDs = new String [_myConfig.getServer(_serverWork).getDisplay().getLines().size()+2];
			attrIDs[0] = _myConfig.getServer(_serverWork).getDisplay().getTri();
			attrIDs[1] = _myConfig.getServer(_serverWork).getQuery().getIdentifiant();
			
			int i=2;
			for (java.util.Iterator j = _myConfig.getServer(_serverWork).getDisplay().getOrdre().iterator(); j.hasNext() ;) {
				String nomAttr = (String)j.next(); 
				attrIDs[i] = ((Line)_myConfig.getServer(_serverWork).getDisplay().getLines().get(nomAttr)).getAttribute();
				i++;
			}	
			LDAPHandler LDAP = new LDAPHandler();
			LDAP.setUrl(_myConfig.getServer(_serverWork).getUrl());
			LDAP.setAttributes(attrIDs);
			LDAP.setMaxEntries(_myConfig.getServer(_serverWork).getQuery().getMaxEntries());
			LDAP.setBase(_myConfig.getServer(_serverWork).getQuery().getBase());
			LDAP.setFilter(filtre);
			LDAP.setScope(_myConfig.getServer(_serverWork).getQuery().getScope());
			NamingEnumeration answer = LDAP.search();	

			int nbRep = 0;
			if (answer!=null){
			
				try{	
					/*Parcours les rponses*/
					while (answer.hasMore()) {
						Personne p = new Personne();
						SearchResult sr;
						try{
							sr = (SearchResult)answer.next();
							nbRep++;
						}
						catch(NamingException e){
							LogService.log(LogService.ERROR,"userInterface:executeQuery() : "+e.toString());
							LDAP.close();
							return(false);			
						}
							
						/*Ajoute l'attribut de tri pour la personne*/
						Attribute attrib = sr.getAttributes().get(attrIDs[0]);
						try{
							p.addTri((String)attrib.get());
						}
						catch(NullPointerException f){
							LogService.log(LogService.ERROR,"userInterface:executeQuery() : L'attribut de tri est nul");
							return(false);				
						}
						catch(NamingException f){
							LogService.log(LogService.ERROR,"userInterface:executeQuery() : Impossible d'ajouter l'attribut de tri dans la rponse");
							return(false);				
						}
							
						/*Ajoute l'attribut identifiant pour la personne*/
						attrib = sr.getAttributes().get(attrIDs[1]);
						try{
							p.setIdentifiant((String)attrib.get());
						}
						catch(NamingException f){
							LogService.log(LogService.ERROR,"userInterface:executeQuery() : Impossible d'ajouter l'attribut identifiant dans la rponse");
							return(false);				
						}
						
						/*Parcours les autres attributs de la rponse et les ajoute pour la perosnne*/
						for (i=2;i<attrIDs.length;i++){
							attrib = sr.getAttributes().get(attrIDs[i]);
							ElmOfAnswer e = new ElmOfAnswer();
							e.setLabel(((Line)_myConfig.getServer(_serverWork).getDisplay().getLines().get(attrIDs[i])).getLabel());
							e.setList(((Line)_myConfig.getServer(_serverWork).getDisplay().getLines().get(attrIDs[i])).getList());
							e.setTabToCard(((Line)_myConfig.getServer(_serverWork).getDisplay().getLines().get(attrIDs[i])).getTabToCard());
							String type = ((Line)_myConfig.getServer(_serverWork).getDisplay().getLines().get(attrIDs[i])).getType();
				
							if (type.equals("direct")){
								/*Rcupration directe dans LDAP de la (des) valeur(s) de cet attribut*/
								try{
									if (attrib!=null){
										e.setValue(attrib.getAll());
									}
									else{
										e.setValue(null);
									}
								}
								catch(NamingException f){
									LogService.log(LogService.ERROR,"userInterface:executeQuery() : "+f.toString());
									return(false);				
								}
							}
							else if (type.equals("table")){
								try{
									/*Rcupration dans la table lie de la valeur de cet attribut*/
									if (attrib!=null){
										Line L = (Line)_myConfig.getServer(_serverWork).getDisplay().getLines().get(attrIDs[i]);
										String nomAttrib = L.getAttribute();
										String nomTable = L.getLinktable();  
										Table T = _myConfig.getTable(nomTable);
										String value = T.getItem(attrib.get(0).toString());
										if (value!=null){
											attrib.clear();
											attrib.add(value);
										}
										e.setValue(attrib.getAll());
									}
									else{
										e.setValue(null);
									}
								}
								catch(NamingException f){
									LogService.log(LogService.ERROR,"userInterface:executeQuery() : "+f.toString());
									return(false);				
								}
							}
							
							
							p.addAttributes(e);
						}
							_result.add(p);
					}
				}	
				catch(javax.naming.SizeLimitExceededException h){
					LogService.log(LogService.INFO,"userInterface:executeQuery() : Nombre maximum de rponses atteind");
					//Il ne faut pas de return car une fois cette exception dclenche, c'est que le nombre maximum de rponses a t atteind
				}
				catch(NamingException e){
					LogService.log(LogService.ERROR,"userInterface:executeQuery() : "+e.toString());
					return(false);				
				}
			}

			LogService.log(
						LogService.ERROR,
						"userInterface::executeQuery() : nb de rponses trouve : "+nbRep);		
						
						 
			LDAP.close();	
					
			return(true);
		}
		else{
			LogService.log(LogService.INFO,"userInterface:executeQuery() : Filtre vide : ");
			return(false);
		}
	}
	
	

/*******************************************************************************************/
/****AFFICHAGE RESULTAT****/
/*******************************************************************************************/		
	

/**
 * @return le code xml complet pour afficher le rsultat
 */
	public String getResultXml(){  
		String xml = "<tagEnglobant ";
		xml +="link=\""+_myConfig.getServer(_serverWork).getDisplay().getLink()+"\"";
		xml +=">\n";
		
		xml += this.getCriteresXml();
		
		xml += this.getEnteteXml();
			
		xml +=this.getReponseXml();	
		
		xml += "</tagEnglobant>\n";
		
		if (this.getNbReponse()==_myConfig.getServer(_serverWork).getQuery().getMaxEntries()){
			xml +="<ALERT>WARN_MAX_ENTRIES</ALERT>\n";
		}	
		
		return xml;
	}


	/**
	 * @return le code xml des critres slectionns
	 */	
	public String getCriteresXml(){
		String xml="";
		
		for (java.util.Iterator j = _critere.keySet().iterator(); j.hasNext() ;) {		
			String cle = (String)j.next();
			String[] s = (String[])_critere.get(cle);
			xml +="<critere ";
			xml +="label=\""+s[0]+"\" value=\""+s[1]+"\" ";
			xml +="/>\n";
		}
		return xml;	
	}

	/**
	 * @return le code xml des entetes de colonnes
	 */		
	public String getEnteteXml(){
		String xml="";
		/*Rpertorie les attributs*/	
	
		for (java.util.Iterator j = _myConfig.getServer(_serverWork).getDisplay().getOrdre().iterator(); j.hasNext() ;) {
			String nomAttr = (String)j.next(); 
			Line e = (Line)_myConfig.getServer(_serverWork).getDisplay().getLines().get(nomAttr);
			xml +="<attributEntete ";
			xml +="display=\""+userInterface.valueToXml(e.getLabel())+"\" ";
			if (e.getList())xml += "list=\"1\" "; 
			else xml += "list=\"0\" "; 
			xml +="/>\n";
		}	
		
		return xml;	
	}

	/**
	 * @return le code xml des rponses
	 */			
	public String getReponseXml(){
				
		boolean hasResult = this.executeQuery();
						
		String xml="";
		
		if (hasResult){
			/*rpertorie les rsultats*/
			for (java.util.Iterator j = _result.iterator(); j.hasNext() ;) {
				Personne e = (Personne)j.next(); 
				xml +=e.toXml();
			}	
		}
		xml+="<NBREPONSES>"+this.getNbReponse()+"</NBREPONSES>\n";
		
		return xml;
	}
	/**
	 * @return le nombre de rsultat trouvs
	 */			
	public int getNbReponse(){
		if (_result!=null)return _result.size();
		else return( 0);
	}


/*******************************************************************************************/
/****GETTER ET SETTER****/
/*******************************************************************************************/		
	
	

	/**
	 * @return Returns le filtre compltement gnr
	 */
	public String getFiltreComplet(){
		return filtre;
	}
	

	/**
	 * @return Returns the _serverView.
	 */
	public Vector getEltDeFiltre() {
		return _eltDeFiltre;
	}
	
	/**
	 * @return Returns the _serverView.
	 */
	public String getServerView() {
		return _serverView;
	}

	/**
	 * @param view The _serverView to set.
	 */
	public void setServerView(String view) {
		_serverView = view;

		/*ECRITURE DU/DES SERVEUR(S) POTENTIEL(S)*/
		if ( (_serverView.equals("*")) || (_serverView.equals("")) ){
			//rcupration des serveurs lus en config
			HashMap listeServer = _myConfig.getAllServers();
			_serverWork = _myConfig.getDefaultServeurKey();	
		}
		else{
			//_serverView.matches(","); ne fonctionne pas
			if (_serverView.indexOf(',')==-1){	
				_serverWork = _serverView;	
			}
			else{
				String[] tabView = _serverView.split(",");
				_serverWork = tabView[0];
			}
		}	
	}
	
	/**
	 * @return Returns the _serverWork.
	 */
	public String getServerWork() {
		return _serverWork;
	}
}
