<?xml version="1.0"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
   
	<xsl:import href = "./CAnnuaireEntete.xsl" />

	<xsl:import href = "./CAnnuaireCritere.xsl" />

   <xsl:template match="tagEnglobant">
   
   <table align="center">  	
   	 	
   	<tr><td>
   	<xsl:call-template name = "entete" />
   	</td></tr>
   	
   	
   	<tr><td>
   	<xsl:call-template name = "critere" />
   	</td></tr>
   	
   	<tr>
   	<td>   	  	
   	
   	<xsl:apply-templates select = "resultat" >   	
   	<xsl:sort select="attributTri/@value"/>
   	</xsl:apply-templates>
   	</td>
   	</tr>
   	
   </table>
   	
   </xsl:template>
   
   

   
<!--AFFICHAGE DES LIGNES RESULTAT-->
   <xsl:template match="resultat">   	
   	<hr />
   	<table border="0" cellpadding="2" cellspacing="2" align="center">
   	
   	<xsl:apply-templates select = "attributRes" />
   
   	
   	<xsl:if test = "../../tagEnglobant/@link!=''">
	   	<tr>
	   	<td colspan="2">   	  	
	   	<a href="{concat(concat(substring-before(../../tagEnglobant/@link,'%uid'),./attributId/@value),substring-after(../../tagEnglobant/@link,'%uid'))}" target="_blank">Pour plus de détail, cliquez ici</a>
	   	</td>
	   	</tr>
   	</xsl:if>
   	
   	</table>
   </xsl:template>
   
   
<!--AFFICHAGE DES LIGNES RESULTAT-->
   <xsl:template match="attributRes">
   <tr>
   <th class="uportal-channel-subtitle" align="left">
      <xsl:value-of select="@display" /> : 
   </th>
   <td class="uportal-channel-text">
   <xsl:for-each select = "valeur">
      <xsl:value-of select="current()/@value" /><br />
   </xsl:for-each>
   </td>
   </tr>
   </xsl:template>
   
   
</xsl:stylesheet>
