<?xml version="1.0"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  	
<xsl:import href = "./CAnnuaireAlertes.xsl" />

 	<xsl:output method="html" encoding="UTF-8" />

   <xsl:param name="baseActionURL">donne par le code</xsl:param>

   <xsl:param name="etat">donne par le code</xsl:param>

   <xsl:param name="annuSelect">donne par le code</xsl:param>

   <xsl:param name="numCanal">donne par le code</xsl:param>
 
 
   <xsl:template match="FORM">  
   
   
         <form action="{$baseActionURL}#monCanal" method="POST" name="myForm{$numCanal}">
            <input type="hidden" value="{$etat}" name="etat" />

            <input type="hidden" value="search" name="action" />

            <input type="hidden" value="me" name="uP_root" />

            <table class="uportal-background-content">

               <xsl:choose>
                  <xsl:when test="count(SERVER)&gt;1">
                     <tr>
                        <th class="uportal-channel-subtitle" align="rigth">
                           <span class="uportal-channel-text">Choisissez un annuaire :</span>
                        </th>

                        <th class="uportal-channel-subtitle" align="left">
                           <select name="annuaire" onchange="document.myForm{$numCanal}.uP_root.value='root';document.myForm{$numCanal}.etat.value='refresh';submit()">
                              <xsl:for-each select="SERVER">
                                 <xsl:choose>
                                    <xsl:when test="$annuSelect=@name">
                                       <option value="{@name}" selected="true">
                                          <xsl:value-of select="@label" />
                                       </option>
                                    </xsl:when>

                                    <xsl:otherwise>
                                       <option value="{@name}">
                                          <xsl:value-of select="@label" />
                                       </option>
                                    </xsl:otherwise>
                                 </xsl:choose>
                              </xsl:for-each>
                           </select>
                        </th>
                     </tr>

                     <xsl:call-template name="FIELDS" />

                     <tr>
                        <td colspan="2" align="center">
                           <input type="submit" class="uportal-button" value="Rechercher" name="recherche" />
                        </td>
                     </tr>
                  </xsl:when>

                  <xsl:when test="count(SERVER)=1">
                     <xsl:call-template name="FIELDS" />

                     <tr>
                        <td colspan="2" align="center">
                           <input type="submit" class="uportal-button"  value="Rechercher" name="recherche" />
                        </td>
                     </tr>
                  </xsl:when>

                  <xsl:otherwise>
                     <tr>
                        <td class="uportal-channel-text">
                           <span class="uportal-channel-text">Aucun serveur n'a été trouvé</span>
                        </td>
                     </tr>
                  </xsl:otherwise>
               </xsl:choose>
            </table>
         </form>
   </xsl:template>

<!--TEMPLATE DE L'AFFICHAGE DES CHAMPS-->
   <xsl:template name="FIELDS">
      <tr>
         <td colspan="2">&#160;</td>
      </tr>

      <tr>
         <td colspan="2">
            <table border="0" class="uportal-background-content">
               <xsl:apply-templates select="FIELD" />
            </table>
         </td>
      </tr>

      <tr>
         <td colspan="2">&#160;</td>
      </tr>
   </xsl:template>

<!--TEMPLATE D'UN CHAMP-->
   <xsl:template match="FIELD">
      <xsl:choose>
         <xsl:when test="@saisie=1">
            <tr>
               <td class="uportal-label">
                  <xsl:value-of select="@label" />
               </td>

               <td>
                  <xsl:choose>
                     <xsl:when test="count(FIELDVALUE)=0">
                        <input type="text" name="{@name}" />
                     </xsl:when>

                     <xsl:otherwise>
                        <select name="{@name}">
                           <xsl:for-each select="FIELDVALUE">
                              <xsl:sort select="@value" />

                              <option value="{@code}">
                                 <xsl:value-of select="@value" />
                              </option>
                           </xsl:for-each>
                        </select>
                     </xsl:otherwise>
                  </xsl:choose>
               </td>
            </tr>
         </xsl:when>

         <xsl:otherwise>
            <input type="hidden" name="{@name}" value="{@value}" />
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
</xsl:stylesheet>

