<?xml version="1.0"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<xsl:import href = "./CAnnuaireAlertes.xsl" />

 	<xsl:import href = "./CAnnuaireEntete.xsl" />

	<xsl:import href = "./CAnnuaireCritere.xsl" />

   <xsl:param name="nomId">donne par le code</xsl:param>

   <xsl:param name="baseActionURL">donne par le code</xsl:param>


   <xsl:template match="tagEnglobant">
   	
   	  	
   	<table align="center">
   	
   	<tr><td>
   	<xsl:call-template name = "entete" />
   	</td></tr>
   
   <xsl:if test="../ALERT!=''">
   	<tr><td>  <xsl:apply-templates select="../ALERT" /> 	
   	
   	</td></tr>
   </xsl:if>
   	
   	
   	<tr><td align="center">
   	<xsl:call-template name = "critere" />
   	</td></tr>
   	   	
   	
   	<tr>
   	<td align="center">
   	
   	<table border="1" cellpadding="2" cellspacing="3"> 
   	
   	<tr class="uportal-background-light">   	
   	<xsl:apply-templates select = "attributEntete" />
   	</tr> 
   	  	
   	
   	<xsl:apply-templates select = "resultat" >   	
   	<xsl:sort select="attributTri/@value"/>
   	</xsl:apply-templates>
   	
   	</table>
   	
   	</td>
   	</tr>
   	
   </table>
   	
   </xsl:template>
   
   

   
   
<!--AFFICHAGE DES ENTETES EN FONCTION DES ATTRIBUTS RECHERCHES-->
   <xsl:template match="attributEntete">   
   <xsl:if test = "@list=1">
   	<th class="uportal-channel-table-caption" ><xsl:value-of select="@display" /></th>
   </xsl:if>
   </xsl:template>
   
<!--AFFICHAGE DES LIGNES RESULTAT-->
   <xsl:template match="resultat">
		<tr>
    		<xsl:apply-templates select = "attributRes" />
		</tr>
   </xsl:template>
   
   
<!--AFFICHAGE DES LIGNES RESULTAT-->
   <xsl:template match="attributRes"> 
	   <xsl:if test = "@list=1">
	   	  <xsl:choose>
		   	  <xsl:when test = "@linkToCard=1">
			   <td class="uportal-channel-text">
			   <a class="uportal-channel-text" href="{$baseActionURL}?etat=detail&amp;id={../attributId/@value}"><xsl:value-of select="valeur/@value" /></a><br />			   
			   </td>
		   	  </xsl:when>
			  
			  <xsl:otherwise>
			   <td class="uportal-channel-text">
			   <xsl:for-each select = "valeur">
			      <xsl:value-of select="current()/@value" /><br />
			   </xsl:for-each>
			   </td>
			  </xsl:otherwise> 
		  </xsl:choose>
	   </xsl:if>
   </xsl:template>
   
   
</xsl:stylesheet>

